"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logDebugMessageFactory = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logDebugMessageFactory = logger => {
  let logMessageCounter = 0;
  return msg => {
    logMessageCounter++;
    logger.debug(`Log Rate Analysis #${logMessageCounter}: ${msg}`);
  };
};
exports.logDebugMessageFactory = logDebugMessageFactory;