"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useData = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
var _public = require("@kbn/kibana-react-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlTimeBuckets = require("@kbn/ml-time-buckets");
var _constants = require("@kbn/aiops-common/constants");
var _use_aiops_app_context = require("./use_aiops_app_context");
var _use_document_count_stats = require("./use_document_count_stats");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_BAR_TARGET = 75;
const useData = (selectedDataView, contextId, searchQuery, onUpdate, selectedSignificantItem, selectedGroup = null, barTarget = DEFAULT_BAR_TARGET, changePointsByDefault = true, timeRange) => {
  const {
    executionContext,
    uiSettings
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  (0, _public.useExecutionContext)(executionContext, {
    name: _constants.AIOPS_PLUGIN_ID,
    type: 'application',
    id: contextId
  });
  const [lastRefresh, setLastRefresh] = (0, _react.useState)(0);
  const _timeBuckets = (0, _mlTimeBuckets.useTimeBuckets)(uiSettings);
  const timefilter = (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: (selectedDataView === null || selectedDataView === void 0 ? void 0 : selectedDataView.timeFieldName) !== undefined,
    autoRefreshSelector: true
  });
  const timeRangeMemoized = (0, _react.useMemo)(() => timefilter.getActiveBounds(),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [lastRefresh, JSON.stringify(timefilter.getTime())]);
  const fieldStatsRequest = (0, _react.useMemo)(() => {
    const timefilterActiveBounds = timeRange !== null && timeRange !== void 0 ? timeRange : timeRangeMemoized;
    if (timefilterActiveBounds !== undefined) {
      var _timefilterActiveBoun, _timefilterActiveBoun2, _timeBuckets$getInter;
      _timeBuckets.setInterval('auto');
      _timeBuckets.setBounds(timefilterActiveBounds);
      _timeBuckets.setBarTarget(barTarget);
      return {
        earliest: (_timefilterActiveBoun = timefilterActiveBounds.min) === null || _timefilterActiveBoun === void 0 ? void 0 : _timefilterActiveBoun.valueOf(),
        latest: (_timefilterActiveBoun2 = timefilterActiveBounds.max) === null || _timefilterActiveBoun2 === void 0 ? void 0 : _timefilterActiveBoun2.valueOf(),
        intervalMs: (_timeBuckets$getInter = _timeBuckets.getInterval()) === null || _timeBuckets$getInter === void 0 ? void 0 : _timeBuckets$getInter.asMilliseconds(),
        index: selectedDataView.getIndexPattern(),
        searchQuery,
        timeFieldName: selectedDataView.timeFieldName,
        runtimeFieldMap: selectedDataView.getRuntimeMappings()
      };
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [lastRefresh, searchQuery, timeRange, timeRangeMemoized]);
  const overallStatsRequest = (0, _react.useMemo)(() => {
    return fieldStatsRequest ? {
      ...fieldStatsRequest,
      selectedSignificantItem,
      selectedGroup,
      includeSelectedSignificantItem: false
    } : undefined;
  }, [fieldStatsRequest, selectedSignificantItem, selectedGroup]);
  const selectedSignificantItemStatsRequest = (0, _react.useMemo)(() => {
    return fieldStatsRequest && (selectedSignificantItem || selectedGroup) ? {
      ...fieldStatsRequest,
      selectedSignificantItem,
      selectedGroup,
      includeSelectedSignificantItem: true
    } : undefined;
  }, [fieldStatsRequest, selectedSignificantItem, selectedGroup]);
  const documentStats = (0, _use_document_count_stats.useDocumentCountStats)(overallStatsRequest, selectedSignificantItemStatsRequest, lastRefresh, changePointsByDefault);
  (0, _react.useEffect)(() => {
    const timefilterUpdateSubscription = (0, _rxjs.merge)(timefilter.getAutoRefreshFetch$(), timefilter.getTimeUpdate$(), _mlDatePicker.mlTimefilterRefresh$).subscribe(done => {
      if (onUpdate) {
        onUpdate({
          time: timefilter.getTime(),
          refreshInterval: timefilter.getRefreshInterval()
        });
        if (typeof done === 'function') {
          done();
        }
      }
      setLastRefresh(Date.now());
    });

    // This listens just for an initial update of the timefilter to be switched on.
    const timefilterEnabledSubscription = timefilter.getEnabledUpdated$().subscribe(() => {
      if (fieldStatsRequest === undefined) {
        setLastRefresh(Date.now());
      }
    });
    return () => {
      timefilterUpdateSubscription.unsubscribe();
      timefilterEnabledSubscription.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return {
    documentStats,
    timefilter,
    /** Start timestamp filter */
    earliest: fieldStatsRequest === null || fieldStatsRequest === void 0 ? void 0 : fieldStatsRequest.earliest,
    /** End timestamp filter */
    latest: fieldStatsRequest === null || fieldStatsRequest === void 0 ? void 0 : fieldStatsRequest.latest,
    intervalMs: fieldStatsRequest === null || fieldStatsRequest === void 0 ? void 0 : fieldStatsRequest.intervalMs,
    forceRefresh: () => setLastRefresh(Date.now())
  };
};
exports.useData = useData;