"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeSampleDocumentsWithFieldCaps = mergeSampleDocumentsWithFieldCaps;
var _lodash = require("lodash");
var _std = require("@kbn/std");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mergeSampleDocumentsWithFieldCaps({
  total,
  hits,
  fieldCaps
}) {
  const nonEmptyFields = new Set();
  const fieldValues = new Map();
  const samples = hits.map(hit => {
    var _hit$_source;
    return {
      ...hit.fields,
      ...(0, _std.getFlattenedObject)((_hit$_source = hit._source) !== null && _hit$_source !== void 0 ? _hit$_source : {})
    };
  });
  const specs = Object.entries(fieldCaps.fields).map(([name, capabilities]) => {
    return {
      name,
      esTypes: Object.keys(capabilities)
    };
  });
  const typesByFields = new Map(specs.map(({
    name,
    esTypes
  }) => {
    return [name, esTypes !== null && esTypes !== void 0 ? esTypes : []];
  }));
  for (const document of samples) {
    Object.keys(document).forEach(field => {
      var _fieldValues$get;
      nonEmptyFields.add(field);
      if (!typesByFields.has(field)) {
        typesByFields.set(field, []);
      }
      const values = (0, _lodash.castArray)(document[field]);
      const currentFieldValues = (_fieldValues$get = fieldValues.get(field)) !== null && _fieldValues$get !== void 0 ? _fieldValues$get : [];
      values.forEach(value => {
        if (typeof value === 'string' || typeof value === 'number' || typeof value === 'boolean') {
          currentFieldValues.push(value);
        }
      });
      fieldValues.set(field, currentFieldValues);
    });
  }
  const fields = Array.from(typesByFields.entries()).flatMap(([name, types]) => {
    const values = fieldValues.get(name);
    const countByValues = new Map();
    values === null || values === void 0 ? void 0 : values.forEach(value => {
      var _countByValues$get;
      const currentCount = (_countByValues$get = countByValues.get(value)) !== null && _countByValues$get !== void 0 ? _countByValues$get : 0;
      countByValues.set(value, currentCount + 1);
    });
    const sortedValues = (0, _lodash.sortBy)(Array.from(countByValues.entries()).map(([value, count]) => {
      return {
        value,
        count
      };
    }), 'count', 'desc');
    return {
      name,
      types,
      empty: !nonEmptyFields.has(name),
      cardinality: countByValues.size || null,
      values: (0, _lodash.uniq)(sortedValues.flatMap(({
        value
      }) => value))
    };
  });
  return {
    total,
    sampled: samples.length,
    fields
  };
}