"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGlobalExecutionKPIRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("../../common");
var _verify_access_and_context = require("./verify_access_and_context");
var _rewrite_namespaces = require("./rewrite_namespaces");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bodySchema = _configSchema.schema.object({
  date_start: _configSchema.schema.string(),
  date_end: _configSchema.schema.maybe(_configSchema.schema.string()),
  filter: _configSchema.schema.maybe(_configSchema.schema.string()),
  namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});
const rewriteReq = ({
  date_start: dateStart,
  date_end: dateEnd,
  namespaces,
  ...rest
}) => ({
  ...rest,
  namespaces: (0, _rewrite_namespaces.rewriteNamespaces)(namespaces),
  dateStart,
  dateEnd
});
const getGlobalExecutionKPIRoute = (router, licenseState) => {
  router.post({
    path: `${_common.INTERNAL_BASE_ACTION_API_PATH}/_global_connector_execution_kpi`,
    security: _constants.DEFAULT_ACTION_ROUTE_SECURITY,
    validate: {
      body: bodySchema
    },
    options: {
      access: 'internal'
    }
  }, router.handleLegacyErrors((0, _verify_access_and_context.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const actionsClient = (await context.actions).getActionsClient();
    return res.ok({
      body: await actionsClient.getGlobalExecutionKpiWithAuth(rewriteReq(req.body))
    });
  })));
};
exports.getGlobalExecutionKPIRoute = getGlobalExecutionKPIRoute;