"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveResolvedValueBindingNode = resolveResolvedValueBindingNode;
const common_1 = require("@inversifyjs/common");
function resolveResolvedValueBindingNode(resolveResolvedValueBindingParams) {
    return (params, node) => {
        const paramValues = resolveResolvedValueBindingParams(params, node);
        if ((0, common_1.isPromise)(paramValues)) {
            return paramValues.then((resolvedParamValues) => node.binding.factory(...resolvedParamValues));
        }
        return node.binding.factory(...paramValues);
    };
}
//# sourceMappingURL=resolveResolvedValueBindingNode.js.map