"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveInstanceBindingConstructorParams = resolveInstanceBindingConstructorParams;
const common_1 = require("@inversifyjs/common");
function resolveInstanceBindingConstructorParams(resolveServiceNode) {
    return (params, node) => {
        const constructorResolvedValues = [];
        for (const constructorParam of node.constructorParams) {
            if (constructorParam === undefined) {
                constructorResolvedValues.push(undefined);
            }
            else {
                constructorResolvedValues.push(resolveServiceNode(params, constructorParam));
            }
        }
        return constructorResolvedValues.some(common_1.isPromise)
            ? Promise.all(constructorResolvedValues)
            : constructorResolvedValues;
    };
}
//# sourceMappingURL=resolveInstanceBindingConstructorParams.js.map