"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveBindingServiceDeactivations = resolveBindingServiceDeactivations;
const common_1 = require("@inversifyjs/common");
function resolveBindingServiceDeactivations(params, serviceIdentifier, value) {
    const deactivations = params.getDeactivations(serviceIdentifier);
    if (deactivations === undefined) {
        return undefined;
    }
    if ((0, common_1.isPromise)(value)) {
        return resolveBindingDeactivationsFromIteratorAsync(value, deactivations[Symbol.iterator]());
    }
    return resolveBindingDeactivationsFromIterator(value, deactivations[Symbol.iterator]());
}
function resolveBindingDeactivationsFromIterator(value, deactivationsIterator) {
    let deactivationIteratorResult = deactivationsIterator.next();
    while (deactivationIteratorResult.done !== true) {
        const nextDeactivationValue = deactivationIteratorResult.value(value);
        if ((0, common_1.isPromise)(nextDeactivationValue)) {
            return resolveBindingDeactivationsFromIteratorAsync(value, deactivationsIterator);
        }
        deactivationIteratorResult = deactivationsIterator.next();
    }
}
async function resolveBindingDeactivationsFromIteratorAsync(value, deactivationsIterator) {
    const resolvedValue = await value;
    let deactivationIteratorResult = deactivationsIterator.next();
    while (deactivationIteratorResult.done !== true) {
        await deactivationIteratorResult.value(resolvedValue);
        deactivationIteratorResult = deactivationsIterator.next();
    }
}
//# sourceMappingURL=resolveBindingServiceDeactivations.js.map