"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateClassMetadataWithTypescriptParameterTypes = updateClassMetadataWithTypescriptParameterTypes;
const reflect_metadata_utils_1 = require("@inversifyjs/reflect-metadata-utils");
const classMetadataReflectKey_1 = require("../../reflectMetadata/data/classMetadataReflectKey");
const typescriptDesignParameterTypesReflectKey_1 = require("../../reflectMetadata/data/typescriptDesignParameterTypesReflectKey");
const buildClassElementMetadataFromTypescriptParameterType_1 = require("../calculations/buildClassElementMetadataFromTypescriptParameterType");
const getDefaultClassMetadata_1 = require("../calculations/getDefaultClassMetadata");
const isUserlandEmittedType_1 = require("../calculations/isUserlandEmittedType");
function updateClassMetadataWithTypescriptParameterTypes(target) {
    const typescriptConstructorArguments = (0, reflect_metadata_utils_1.getOwnReflectMetadata)(target, typescriptDesignParameterTypesReflectKey_1.typescriptParameterTypesReflectKey);
    if (typescriptConstructorArguments !== undefined) {
        (0, reflect_metadata_utils_1.updateOwnReflectMetadata)(target, classMetadataReflectKey_1.classMetadataReflectKey, getDefaultClassMetadata_1.getDefaultClassMetadata, updateMaybeClassMetadataWithTypescriptClassMetadata(typescriptConstructorArguments));
    }
}
function updateMaybeClassMetadataWithTypescriptClassMetadata(typescriptConstructorArguments) {
    return (classMetadata) => {
        typescriptConstructorArguments.forEach((constructorArgumentType, index) => {
            if (classMetadata.constructorArguments[index] === undefined &&
                (0, isUserlandEmittedType_1.isUserlandEmittedType)(constructorArgumentType)) {
                classMetadata.constructorArguments[index] =
                    (0, buildClassElementMetadataFromTypescriptParameterType_1.buildClassElementMetadataFromTypescriptParameterType)(constructorArgumentType);
            }
        });
        return classMetadata;
    };
}
//# sourceMappingURL=updateClassMetadataWithTypescriptParameterTypes.js.map