"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurrentEuiBreakpointProvider = exports.CurrentEuiBreakpointContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("../../components/common");
var _hooks = require("../theme/hooks");
var _throttle = require("../throttle");
var _sorting = require("./_sorting");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var CurrentEuiBreakpointContext = exports.CurrentEuiBreakpointContext = /*#__PURE__*/(0, _react.createContext)(undefined);

/**
 * Returns the current breakpoint based on window width.
 * Typically only called by the top-level `EuiProvider` (to reduce the number
 * of window resize listeners on the page). Also conditionally called if a
 * nested `EuiThemeProvider` defines a `modify.breakpoint` override
 */
var CurrentEuiBreakpointProvider = exports.CurrentEuiBreakpointProvider = function CurrentEuiBreakpointProvider(_ref) {
  var children = _ref.children;
  // Obtain the breakpoints map from the EUI theme
  var _useEuiTheme = (0, _hooks.useEuiTheme)(),
    breakpoints = _useEuiTheme.euiTheme.breakpoint;

  // Ensure the breakpoints map is sorted from largest value to smallest
  var sortedBreakpoints = (0, _react.useMemo)(function () {
    return (0, _sorting.sortMapByLargeToSmallValues)(breakpoints);
  }, [breakpoints]);

  // Find the breakpoint (key) whose value is <= windowWidth starting with largest first
  var getBreakpoint = (0, _react.useCallback)(function (width) {
    return (0, _common.keysOf)(sortedBreakpoints).find(function (key) {
      return sortedBreakpoints[key] <= width;
    });
  }, [sortedBreakpoints]);
  var _useState = (0, _react.useState)(typeof window !== 'undefined' ? getBreakpoint(window.innerWidth) : undefined),
    _useState2 = _slicedToArray(_useState, 2),
    currentBreakpoint = _useState2[0],
    setCurrentBreakpoint = _useState2[1];
  (0, _react.useEffect)(function () {
    var onWindowResize = (0, _throttle.throttle)(function () {
      setCurrentBreakpoint(getBreakpoint(window.innerWidth));
    }, 50);
    window.addEventListener('resize', onWindowResize);
    return function () {
      return window.removeEventListener('resize', onWindowResize);
    };
  }, [getBreakpoint]);
  return (0, _react2.jsx)(CurrentEuiBreakpointContext.Provider, {
    value: currentBreakpoint
  }, children);
};