"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flyoutReducer = flyoutReducer;
exports.initialFlyoutState = void 0;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Initial state for the flyout session
 * @internal
 */
var initialFlyoutState = exports.initialFlyoutState = {
  activeFlyoutGroup: null,
  history: []
};

// Helper to apply size constraints for flyout groups
var applySizeConstraints = function applySizeConstraints(group) {
  var originalMainSize = group.config.mainSize;
  var originalChildSize = group.config.childSize;
  var newMainSize = originalMainSize;
  var newChildSize = originalChildSize;
  if (group.isChildOpen) {
    if (originalMainSize === 'l') {
      newMainSize = 'm'; // If main is 'l' with child, it must be converted to 'm'
      newChildSize = 's'; // And child must be 's'
    } else if (originalMainSize === 'm' && originalChildSize !== 's') {
      newChildSize = 's'; // If main is 'm' with child, child must be 's'
    }
  }

  // If sizes haven't changed, return the original group to preserve references
  if (newMainSize === originalMainSize && newChildSize === originalChildSize) {
    return group;
  }
  return _objectSpread(_objectSpread({}, group), {}, {
    config: _objectSpread(_objectSpread({}, group.config), {}, {
      mainSize: newMainSize,
      childSize: newChildSize
    })
  });
};

/**
 * Flyout reducer
 * Controls state changes for flyout groups
 */
function flyoutReducer(state, action) {
  switch (action.type) {
    case 'OPEN_MAIN_FLYOUT':
      {
        var _action$payload = action.payload,
          size = _action$payload.size,
          flyoutProps = _action$payload.flyoutProps,
          meta = _action$payload.meta;
        var newHistory = _toConsumableArray(state.history);
        if (state.activeFlyoutGroup) {
          newHistory.push(state.activeFlyoutGroup);
        }
        var newActiveGroup = {
          isMainOpen: true,
          isChildOpen: false,
          config: {
            mainSize: size,
            mainFlyoutProps: flyoutProps
          },
          meta: meta
        };
        return {
          activeFlyoutGroup: applySizeConstraints(newActiveGroup),
          history: newHistory
        };
      }
    case 'OPEN_CHILD_FLYOUT':
      {
        if (!state.activeFlyoutGroup || !state.activeFlyoutGroup.isMainOpen) {
          console.warn('Cannot open child flyout: main flyout is not open or no active group.');
          return state;
        }
        var _action$payload2 = action.payload,
          _size = _action$payload2.size,
          _flyoutProps = _action$payload2.flyoutProps,
          _meta = _action$payload2.meta;
        var updatedActiveGroup = _objectSpread(_objectSpread({}, state.activeFlyoutGroup), {}, {
          isChildOpen: true,
          config: _objectSpread(_objectSpread({}, state.activeFlyoutGroup.config), {}, {
            childSize: _size,
            childFlyoutProps: _flyoutProps
          }),
          meta: _meta
        });
        return {
          history: state.history,
          activeFlyoutGroup: applySizeConstraints(updatedActiveGroup)
        };
      }
    case 'OPEN_FLYOUT_GROUP':
      {
        var _action$payload3 = action.payload,
          main = _action$payload3.main,
          child = _action$payload3.child,
          _meta2 = _action$payload3.meta;
        var _newHistory = _toConsumableArray(state.history);
        if (state.activeFlyoutGroup) {
          _newHistory.push(state.activeFlyoutGroup);
        }

        // Create the new active group with both main and child flyouts open
        var _newActiveGroup = {
          isMainOpen: true,
          isChildOpen: true,
          config: {
            mainSize: main.size,
            childSize: child.size,
            mainFlyoutProps: main.flyoutProps,
            childFlyoutProps: child.flyoutProps
          },
          meta: _meta2
        };
        return {
          activeFlyoutGroup: applySizeConstraints(_newActiveGroup),
          history: _newHistory
        };
      }
    case 'CLOSE_CHILD_FLYOUT':
      {
        if (!state.activeFlyoutGroup || !state.activeFlyoutGroup.isChildOpen) {
          console.warn('Cannot close child flyout: no child is open or no active group.');
          return state;
        }
        var _updatedActiveGroup = _objectSpread(_objectSpread({}, state.activeFlyoutGroup), {}, {
          isChildOpen: false,
          config: _objectSpread(_objectSpread({}, state.activeFlyoutGroup.config), {}, {
            childFlyoutProps: {}
          })
        });
        return {
          history: state.history,
          activeFlyoutGroup: applySizeConstraints(_updatedActiveGroup)
        };
      }
    case 'GO_BACK':
      {
        if (!state.activeFlyoutGroup) return initialFlyoutState;

        // Restore from history or return to initial state
        if (state.history.length > 0) {
          var _newHistory2 = _toConsumableArray(state.history);
          var previousGroup = _newHistory2.pop();
          return {
            activeFlyoutGroup: previousGroup ? applySizeConstraints(previousGroup) : null,
            history: _newHistory2
          };
        } else {
          return initialFlyoutState;
        }
      }
    case 'UPDATE_ACTIVE_FLYOUT_CONFIG':
      {
        if (!state.activeFlyoutGroup) {
          console.warn('Cannot update config: no active flyout group.');
          return state;
        }
        var configChanges = action.payload.configChanges;
        var _updatedActiveGroup2 = _objectSpread(_objectSpread({}, state.activeFlyoutGroup), {}, {
          config: _objectSpread(_objectSpread({}, state.activeFlyoutGroup.config), configChanges)
        });
        var finalUpdatedActiveGroup = applySizeConstraints(_updatedActiveGroup2);
        return _objectSpread(_objectSpread({}, state), {}, {
          activeFlyoutGroup: finalUpdatedActiveGroup
        });
      }
    case 'CLOSE_SESSION':
      // Remove the active group and close the session
      return {
        activeFlyoutGroup: null,
        history: []
      };
    default:
      return state;
  }
}