"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridColumnResizer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../../../services");
var _global_styling = require("../../../../global_styling");
var _draggable_columns = require("./draggable_columns");
var _column_resizer = require("./column_resizer.styles");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var MINIMUM_COLUMN_WIDTH = 40;
var EuiDataGridColumnResizer = exports.EuiDataGridColumnResizer = /*#__PURE__*/function (_Component) {
  function EuiDataGridColumnResizer() {
    var _this;
    _classCallCheck(this, EuiDataGridColumnResizer);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiDataGridColumnResizer, [].concat(args));
    _defineProperty(_this, "state", {
      initialX: 0,
      offset: 0
    });
    _defineProperty(_this, "onMouseDown", function (e) {
      _this.setState({
        initialX: e.pageX
      });
      window.addEventListener('mouseup', _this.onMouseUp);
      window.addEventListener('blur', _this.onMouseUp);
      window.addEventListener('mousemove', _this.onMouseMove);

      // don't let this action steal focus
      e.preventDefault();
    });
    _defineProperty(_this, "onMouseUp", function () {
      var offset = _this.state.offset;
      var _this$props = _this.props,
        columnId = _this$props.columnId,
        columnWidth = _this$props.columnWidth,
        setColumnWidth = _this$props.setColumnWidth;
      setColumnWidth(columnId, Math.max(MINIMUM_COLUMN_WIDTH, columnWidth + offset));
      _this.setState({
        offset: 0
      });
      window.removeEventListener('mouseup', _this.onMouseUp);
      window.removeEventListener('blur', _this.onMouseUp);
      window.removeEventListener('mousemove', _this.onMouseMove);
    });
    _defineProperty(_this, "onMouseMove", function (e) {
      var columnWidth = _this.props.columnWidth;
      _this.setState(function (_ref) {
        var initialX = _ref.initialX;
        return {
          offset: Math.max(e.pageX - initialX, -(columnWidth - MINIMUM_COLUMN_WIDTH))
        };
      });
    });
    return _this;
  }
  _inherits(EuiDataGridColumnResizer, _Component);
  return _createClass(EuiDataGridColumnResizer, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var offset = this.state.offset;
      var isLastColumn = this.props.isLastColumn;
      return (0, _react2.jsx)(_services.RenderWithEuiStylesMemoizer, null, function (stylesMemoizer) {
        var styles = stylesMemoizer(_column_resizer.euiDataGridColumnResizerStyles);
        var cssStyles = [styles.euiDataGridColumnResizer, isLastColumn && styles.isLastColumn, offset && styles.isDragging];
        return (0, _react2.jsx)("div", {
          css: cssStyles,
          className: "euiDataGridColumnResizer",
          "data-test-subj": "dataGridColumnResizer",
          style: offset ? (0, _global_styling.logicalStyle)('margin-right', "".concat(-offset, "px")) : undefined,
          onMouseDown: _this2.onMouseDown
        }, (0, _react2.jsx)(_draggable_columns.DragOverlay, {
          isDragging: !!offset,
          cursor: "ew-resize"
        }));
      });
    }
  }]);
}(_react.Component);
EuiDataGridColumnResizer.propTypes = {
  columnId: _propTypes.default.string.isRequired,
  columnWidth: _propTypes.default.number.isRequired,
  setColumnWidth: _propTypes.default.func.isRequired,
  isLastColumn: _propTypes.default.bool.isRequired
};