"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseLineRanges = exports.nodeToHtml = exports.isAstElement = exports.highlightByLine = exports.getHtmlContent = exports.checkSupportedLanguage = exports.SUPPORTED_LANGUAGES = exports.NEW_LINE_REGEX_GLOBAL = exports.NEW_LINE_REGEX = exports.DEFAULT_LANGUAGE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _refractor = require("refractor");
var _css = require("@emotion/css");
var _prismjsEsql = require("@elastic/prismjs-esql");
var _code_block_annotations = require("./code_block_annotations");
var _code_block_line = require("./code_block_line.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
(0, _refractor.register)(_prismjsEsql.esql);

/**
 * Utils shared between EuiCode and EuiCodeBlock
 */

var SUPPORTED_LANGUAGES = exports.SUPPORTED_LANGUAGES = (0, _refractor.listLanguages)();
var DEFAULT_LANGUAGE = exports.DEFAULT_LANGUAGE = 'text';

/**
 * Platform-agnostic new line regex that safely matches all standard
 * line termination conventions:
 * - LF: Unix-based platforms and JS-native sources like text areas
 * - CRLF: Windows
 * - CR: Mac Classic; to support files saved a long time ago
 */
var NEW_LINE_REGEX = exports.NEW_LINE_REGEX = /\r\n|\r|\n/;

/**
 * Platform-agnostic global new line regex that safely matches all standard
 * line termination conventions.
 * See [NEW_LINE_REGEX]{@link NEW_LINE_REGEX} for more details.
 */
var NEW_LINE_REGEX_GLOBAL = exports.NEW_LINE_REGEX_GLOBAL = new RegExp(NEW_LINE_REGEX, 'g');
var checkSupportedLanguage = exports.checkSupportedLanguage = function checkSupportedLanguage(language) {
  return SUPPORTED_LANGUAGES.includes(language) ? language : DEFAULT_LANGUAGE;
};
var getHtmlContent = exports.getHtmlContent = function getHtmlContent(data, children) {
  if (!Array.isArray(data) || data.length < 1) {
    return children;
  }
  return data.map(nodeToHtml);
};
var isAstElement = exports.isAstElement = function isAstElement(node) {
  return node.hasOwnProperty('type') && node.type === 'element';
};
var nodeToHtml = exports.nodeToHtml = function nodeToHtml(node, idx, nodes) {
  var depth = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
  var key = "node-".concat(depth, "-").concat(idx);
  if (isAstElement(node)) {
    var properties = node.properties,
      tagName = node.tagName,
      children = node.children;
    return /*#__PURE__*/(0, _react.createElement)(tagName, _objectSpread(_objectSpread({}, properties), {}, {
      key: key,
      className: (0, _css.cx)(properties.className)
    }), children && children.map(function (el, i) {
      return (
        // @ts-ignore - using a custom type here to handle JSX annotations
        el.type === 'annotation' ? (0, _react2.jsx)(_code_block_annotations.EuiCodeBlockAnnotation, {
          className: "euiCodeBlock__lineAnnotation",
          lineNumber: el.lineNumber,
          children: el.annotation,
          key: i
        }) : nodeToHtml(el, i, nodes, depth + 1)
      );
    }));
  }
  return (0, _react2.jsx)(_react.default.Fragment, {
    key: key
  }, node.value);
};

/**
 * Line utils specific to EuiCodeBlock
 */

// Approximate width of a single digit/character
var CHAR_SIZE = 8;

// Creates an array of numbers from comma-separeated
// string of numbers or number ranges using `-`
// (e.g., "1, 3-10, 15")
var parseLineRanges = exports.parseLineRanges = function parseLineRanges(ranges) {
  var highlights = [];
  ranges.replace(/\s/g, '').split(',').forEach(function (line) {
    if (line.includes('-')) {
      var range = line.split('-').map(Number);
      for (var i = range[0]; i <= range[1]; i++) {
        highlights.push(i);
      }
    } else {
      highlights.push(Number(line));
    }
  });
  return highlights;
};
var addLineData = function addLineData(nodes, data) {
  return nodes.reduce(function (result, node) {
    var lineStart = data.lineNumber;
    if (node.type === 'text') {
      if (!node.value.match(NEW_LINE_REGEX)) {
        node.lineStart = lineStart;
        node.lineEnd = lineStart;
        result.push(node);
      } else {
        var lines = node.value.split(NEW_LINE_REGEX);
        lines.forEach(function (line, i) {
          var num = i === 0 ? data.lineNumber : ++data.lineNumber;
          result.push({
            type: 'text',
            value: i === lines.length - 1 ? line : "".concat(line, "\n"),
            lineStart: num,
            lineEnd: num
          });
        });
      }
      return result;
    }
    if (node.children && node.children.length) {
      var _first$lineStart, _last$lineEnd;
      var children = addLineData(node.children, data);
      var first = children[0];
      var last = children[children.length - 1];
      var start = (_first$lineStart = first.lineStart) !== null && _first$lineStart !== void 0 ? _first$lineStart : lineStart;
      var end = (_last$lineEnd = last.lineEnd) !== null && _last$lineEnd !== void 0 ? _last$lineEnd : lineStart;
      if (start !== end) {
        children.forEach(function (node) {
          result.push(node);
        });
      } else {
        node.lineStart = start;
        node.lineEnd = end;
        node.children = children;
        result.push(node);
      }
      return result;
    }
    result.push(node);
    return result;
  }, []);
};
function wrapLines(nodes, options, euiTheme) {
  var grouped = [];
  nodes.forEach(function (node) {
    var lineStart = node.lineStart - 1;
    if (grouped[lineStart]) {
      grouped[lineStart].push(node);
    } else {
      grouped[lineStart] = [node];
    }
  });
  var wrapped = [];
  grouped.forEach(function (node, i) {
    var children = node;
    var styles = (0, _code_block_line.euiCodeBlockLineStyles)(euiTheme);
    var lineStyles = (0, _css.cx)([styles.euiCodeBlock__line, options.showLineNumbers && styles.hasLineNumbers]);
    if (options.showLineNumbers) {
      var _options$annotations;
      var lineNumber = i + 1;
      var digits = grouped.length.toString().length;
      var width = digits * CHAR_SIZE;

      // Line text element and highlights
      var highlights = options.highlight ? parseLineRanges(options.highlight) : [];
      var lineTextStyles = (0, _css.cx)([styles.lineText.euiCodeBlock__lineText, highlights.includes(lineNumber) && styles.lineText.isHighlighted]);
      var lineTextElement = {
        type: 'element',
        tagName: 'span',
        properties: {
          className: ['euiCodeBlock__lineText', lineTextStyles]
        },
        children: node
      };

      // Line number column/wrapper
      var lineNumberWrapperStyles = (0, _css.cx)(styles.lineNumber.euiCodeBlock__lineNumberWrapper);
      var lineNumberWrapperElement = {
        type: 'element',
        tagName: 'span',
        properties: {
          style: {
            inlineSize: width
          },
          className: ['euiCodeBlock__lineNumberWrapper', lineNumberWrapperStyles]
        },
        children: []
      };

      // Line number element
      var lineNumberStyles = (0, _css.cx)(styles.lineNumber.euiCodeBlock__lineNumber);
      var lineNumberElement = {
        type: 'element',
        tagName: 'span',
        properties: _defineProperty(_defineProperty({
          className: ['euiCodeBlock__lineNumber', lineNumberStyles]
        }, 'data-line-number', lineNumber), 'aria-hidden', true),
        children: []
      };
      lineNumberWrapperElement.children.push(lineNumberElement);

      // Annotation element
      var hasAnnotation = (_options$annotations = options.annotations) === null || _options$annotations === void 0 ? void 0 : _options$annotations.hasOwnProperty(lineNumber);
      if (hasAnnotation) {
        var annotationElement = {
          type: 'annotation',
          annotation: options.annotations[lineNumber],
          lineNumber: lineNumber
        };
        lineNumberWrapperElement.children.push(annotationElement);
      }
      children = [lineNumberWrapperElement, lineTextElement];
    }
    wrapped.push({
      type: 'element',
      tagName: 'span',
      properties: {
        className: ['euiCodeBlock__line', lineStyles]
      },
      children: children
    });
  });
  return wrapped;
}
var highlightByLine = exports.highlightByLine = function highlightByLine(children, language, data, euiTheme) {
  return wrapLines(addLineData((0, _refractor.highlight)(children, language), {
    lineNumber: data.start
  }), {
    showLineNumbers: data.show,
    highlight: data.highlight,
    annotations: data.annotations
  }, euiTheme);
};