"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIS_COLOR_STORE_EVENTS = exports.EuiVisColorStore = void 0;
var _isEqual = _interopRequireDefault(require("lodash/isEqual"));
var _lodash = require("lodash");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var VIS_COLOR_STORE_EVENTS = exports.VIS_COLOR_STORE_EVENTS = {
  UPDATE: 'UPDATE'
};
var EuiVisColorStoreImpl = /*#__PURE__*/function () {
  function EuiVisColorStoreImpl(dependencies) {
    var _this = this;
    _classCallCheck(this, EuiVisColorStoreImpl);
    _defineProperty(this, "_visColors", void 0);
    _defineProperty(this, "_hasVisColorAdjustment", void 0);
    _defineProperty(this, "events", {});
    _defineProperty(this, "setVisColors", function (colors, hasColorAdjustment) {
      if (!(0, _isEqual["default"])(_this._visColors, colors) || hasColorAdjustment !== _this._hasVisColorAdjustment) {
        _this._visColors = colors;
        if (hasColorAdjustment != null) {
          _this._hasVisColorAdjustment = hasColorAdjustment;
        }
        _this.publishUpdate(VIS_COLOR_STORE_EVENTS.UPDATE, _this._visColors);
      }
    });
    _defineProperty(this, "subscribe", function (eventName, callback) {
      if (_this.events[eventName] == null) {
        _this.events[eventName] = new Map();
      }
      var id = (0, _lodash.uniqueId)("".concat(eventName, "_"));
      _this.events[eventName].set(id, callback);
      return id;
    });
    _defineProperty(this, "unsubscribe", function (eventName, id) {
      if (_this.events[eventName] != null && _this.events[eventName].has(id)) {
        _this.events[eventName]["delete"](id);
      }
    });
    _defineProperty(this, "publishUpdate", function (eventName, colors) {
      if (_this.events[eventName]) _this.events[eventName].forEach(function (callback) {
        // use timeout to execute callbacks after theme updates
        setTimeout(function () {
          callback === null || callback === void 0 || callback(colors);
        });
      });
    });
    this._visColors = dependencies.defaultColors;
    this._hasVisColorAdjustment = dependencies.hasVisColorAdjustment;
  }
  return _createClass(EuiVisColorStoreImpl, [{
    key: "visColors",
    get: function get() {
      return this._visColors;
    }
  }, {
    key: "hasVisColorAdjustment",
    get: function get() {
      return this._hasVisColorAdjustment;
    }
  }]);
}();
var EuiVisColorStore = exports.EuiVisColorStore = /*#__PURE__*/function () {
  function EuiVisColorStore() {
    _classCallCheck(this, EuiVisColorStore);
  }
  return _createClass(EuiVisColorStore, null, [{
    key: "getInstance",
    value: function getInstance(defaultColors, hasVisColorAdjustment) {
      if (!this.instance) {
        this.instance = new EuiVisColorStoreImpl({
          defaultColors: defaultColors,
          hasVisColorAdjustment: hasVisColorAdjustment
        });
      }
      return this.instance;
    }
  }]);
}();
_defineProperty(EuiVisColorStore, "instance", void 0);