"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AMSTERDAM_DARK_THEME = void 0;
const legacy_colors_1 = require("./legacy_colors");
const theme_common_1 = require("./theme_common");
const colors_1 = require("../../common/colors");
const constants_1 = require("../../common/constants");
const default_theme_attributes_1 = require("../../common/default_theme_attributes");
const common_1 = require("../common");
exports.AMSTERDAM_DARK_THEME = {
    chartPaddings: theme_common_1.DEFAULT_CHART_PADDING,
    chartMargins: theme_common_1.DEFAULT_CHART_MARGINS,
    lineSeriesStyle: {
        line: {
            visible: true,
            strokeWidth: 2,
            opacity: 1,
            dimmed: { opacity: 0.25 },
            focused: { strokeWidth: 1 },
        },
        point: {
            visible: 'auto',
            strokeWidth: 0,
            stroke: common_1.ColorVariant.None,
            fill: common_1.ColorVariant.Series,
            radius: 3,
            opacity: 1,
            dimmed: { opacity: 0.25 },
        },
        isolatedPoint: {
            enabled: true,
            visible: 'auto',
            strokeWidth: 0,
            stroke: common_1.ColorVariant.None,
            fill: common_1.ColorVariant.Series,
            opacity: 1,
        },
        fit: {
            line: {
                visible: true,
                dash: [5, 5],
                stroke: common_1.ColorVariant.Series,
                opacity: 1,
            },
        },
        pointVisibilityMinDistance: 40,
    },
    bubbleSeriesStyle: {
        point: {
            visible: 'always',
            strokeWidth: 1,
            fill: colors_1.Colors.Black.keyword,
            radius: 2,
            opacity: 1,
            dimmed: { opacity: 0.25 },
        },
    },
    areaSeriesStyle: {
        area: {
            visible: true,
            opacity: 0.3,
            dimmed: { opacity: 0.25 },
        },
        line: {
            visible: true,
            strokeWidth: 2,
            opacity: 1,
            dimmed: { opacity: 0.25 },
            focused: { strokeWidth: 1 },
        },
        point: {
            visible: 'never',
            strokeWidth: 0,
            stroke: common_1.ColorVariant.None,
            fill: common_1.ColorVariant.Series,
            radius: 3,
            opacity: 1,
            dimmed: { opacity: 0.25 },
        },
        isolatedPoint: {
            enabled: true,
            visible: 'auto',
            stroke: common_1.ColorVariant.None,
            strokeWidth: 0,
            fill: common_1.ColorVariant.Series,
            opacity: 1,
        },
        fit: {
            line: {
                visible: true,
                dash: [5, 5],
                stroke: common_1.ColorVariant.Series,
                opacity: 1,
            },
            area: {
                visible: true,
                opacity: 0.15,
                fill: common_1.ColorVariant.Series,
            },
        },
        pointVisibilityMinDistance: 20,
    },
    barSeriesStyle: {
        rect: {
            opacity: 1,
        },
        rectBorder: {
            visible: false,
            strokeWidth: 1,
        },
        displayValue: {
            fontSize: 10,
            fontStyle: 'normal',
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            alignment: { horizontal: 'center', vertical: 'middle' },
            padding: 0,
            fill: { textBorder: 0 },
            offsetX: 0,
            offsetY: 0,
        },
    },
    arcSeriesStyle: {
        arc: {
            visible: true,
            stroke: 'white',
            strokeWidth: 1,
            opacity: 1,
        },
    },
    sharedStyle: theme_common_1.DEFAULT_GEOMETRY_STYLES,
    scales: {
        barsPadding: 0.25,
        histogramPadding: 0.05,
    },
    axes: {
        axisTitle: {
            fontSize: 12,
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            padding: {
                inner: 10,
                outer: 0,
            },
            fill: '#DFE5EF',
            visible: true,
        },
        axisPanelTitle: {
            fontSize: 10,
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            padding: {
                inner: 8,
                outer: 0,
            },
            fill: '#D4D4D4',
            visible: true,
        },
        axisLine: {
            visible: true,
            stroke: '#343741',
            strokeWidth: 1,
        },
        tickLabel: {
            visible: true,
            fontSize: 10,
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fontStyle: 'normal',
            fill: '#81858f',
            padding: { outer: 8, inner: 10 },
            rotation: 0,
            offset: {
                x: 0,
                y: 0,
                reference: 'local',
            },
            alignment: {
                vertical: 'near',
                horizontal: 'near',
            },
        },
        tickLine: {
            visible: false,
            stroke: '#343741',
            strokeWidth: 1,
            size: 10,
            padding: 10,
        },
        gridLine: {
            horizontal: {
                visible: true,
                stroke: '#343741',
                strokeWidth: 1,
                opacity: 1,
                dash: [0, 0],
            },
            vertical: {
                visible: true,
                stroke: '#343741',
                strokeWidth: 1,
                opacity: 1,
                dash: [0, 0],
            },
        },
    },
    colors: {
        vizColors: legacy_colors_1.palettes.echPaletteColorBlind.colors,
        defaultVizColor: '#6092C0',
    },
    legend: {
        verticalWidth: 200,
        horizontalHeight: 64,
        spacingBuffer: 10,
        margin: 0,
        labelOptions: {
            maxLines: 1,
        },
    },
    crosshair: {
        band: {
            visible: true,
            fill: '#2a2b33',
        },
        line: {
            visible: true,
            stroke: '#98A2B3',
            strokeWidth: 1,
            dash: [4, 4],
        },
        crossLine: {
            visible: true,
            stroke: '#98A2B3',
            strokeWidth: 1,
            dash: [4, 4],
        },
    },
    background: {
        color: '#1D1E24',
        fallbackColor: '#1D1E24',
    },
    goal: {
        minFontSize: 8,
        maxFontSize: 64,
        maxCircularSize: 360,
        maxBulletSize: 500,
        barThicknessMinSizeRatio: 1 / 10,
        baselineArcThickness: 32,
        baselineBarThickness: 32,
        marginRatio: 0.05,
        maxTickFontSize: 24,
        maxLabelFontSize: 32,
        maxCentralFontSize: 38,
        arcBoxSamplePitch: (5 / 360) * constants_1.TAU,
        capturePad: 16,
        tickLabel: {
            fontStyle: 'normal',
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fill: '#81858f',
        },
        majorLabel: {
            fontStyle: 'normal',
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fill: '#DFE5EF',
        },
        minorLabel: {
            fontStyle: 'normal',
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fill: '#81858f',
        },
        majorCenterLabel: {
            fontStyle: 'normal',
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fill: '#DFE5EF',
        },
        minorCenterLabel: {
            fontStyle: 'normal',
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fill: '#81858f',
        },
        targetLine: {
            stroke: '#D4DAE5',
        },
        tickLine: {
            stroke: '#535966',
        },
        progressLine: {
            stroke: '#D4DAE5',
        },
    },
    partition: {
        outerSizeRatio: 1,
        emptySizeRatio: 0,
        fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
        minFontSize: 8,
        maxFontSize: 64,
        idealFontSizeJump: 1.05,
        maximizeFontSize: false,
        circlePadding: 4,
        radialPadding: constants_1.TAU / 360,
        horizontalTextAngleThreshold: constants_1.TAU / 12,
        horizontalTextEnforcer: 1,
        fillLabel: {
            textColor: common_1.ColorVariant.Adaptive,
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fontStyle: 'normal',
            fontVariant: 'normal',
            fontWeight: 400,
            valueFont: {
                fontWeight: 700,
                fontStyle: 'normal',
                fontVariant: 'normal',
            },
            padding: 2,
            clipText: false,
        },
        linkLabel: {
            maximumSection: 10,
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fontSize: 11,
            fontStyle: 'normal',
            fontVariant: 'normal',
            fontWeight: 400,
            gap: 10,
            spacing: 2,
            horizontalStemLength: 10,
            radiusPadding: 10,
            lineWidth: 1,
            maxCount: 5,
            maxTextLength: 100,
            textColor: '#DFE5EF',
            minimumStemLength: 0,
            stemAngle: constants_1.TAU / 8,
            padding: 0,
            valueFont: {
                fontWeight: 400,
                fontStyle: 'normal',
                fontVariant: 'normal',
            },
        },
        sectorLineWidth: 1.5,
        sectorLineStroke: '#1D1E24',
    },
    heatmap: {
        brushArea: {
            visible: true,
            stroke: '#D3DAE6',
            strokeWidth: 2,
        },
        brushMask: {
            visible: true,
            fill: '#8c8c8c80',
        },
        brushTool: {
            visible: false,
            fill: 'snow',
        },
        xAxisLabel: {
            visible: true,
            fontSize: 12,
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fontStyle: 'normal',
            textColor: 'white',
            fontVariant: 'normal',
            fontWeight: 'normal',
            padding: { top: 5, bottom: 5, left: 5, right: 5 },
            rotation: 0,
        },
        yAxisLabel: {
            visible: true,
            width: 'auto',
            fontSize: 12,
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fontStyle: 'normal',
            textColor: 'white',
            fontVariant: 'normal',
            fontWeight: 'normal',
            padding: { top: 5, bottom: 5, left: 5, right: 5 },
        },
        grid: {
            stroke: {
                width: 1,
                color: 'snow',
            },
        },
        cell: {
            maxWidth: 'fill',
            maxHeight: 'fill',
            align: 'center',
            label: {
                visible: true,
                maxWidth: 'fill',
                minFontSize: 8,
                maxFontSize: 12,
                fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
                fontStyle: 'normal',
                textColor: colors_1.Colors.White.keyword,
                fontVariant: 'normal',
                fontWeight: 'normal',
                useGlobalMinFontSize: true,
            },
            border: {
                strokeWidth: 0,
                stroke: 'snow',
            },
        },
    },
    metric: {
        textLightColor: '#E0E5EE',
        textDarkColor: '#343741',
        textSubtitleLightColor: '#E0E5EE',
        textSubtitleDarkColor: '#343741',
        textExtraLightColor: '#E0E5EE',
        textExtraDarkColor: '#343741',
        valueFontSize: 'default',
        minValueFontSize: 12,
        titlesTextAlign: 'left',
        extraTextAlign: 'right',
        valueTextAlign: 'right',
        valuePosition: 'bottom',
        iconAlign: 'right',
        border: '#343741',
        barBackground: '#343741',
        emptyBackground: colors_1.Colors.Transparent.keyword,
        nonFiniteText: 'N/A',
        minHeight: 64,
        titleWeight: 'bold',
    },
    bulletGraph: {
        textColor: '#E0E5EE',
        border: '#343741',
        barBackground: '#FFF',
        colorBands: ['#6092C0', '#3F4E61'],
        nonFiniteText: 'N/A',
        minHeight: 64,
        angularTickLabelPadding: 10,
        fallbackBandColor: '#535966',
    },
    tooltip: {
        maxWidth: 500,
        maxTableHeight: 120,
        defaultDotColor: colors_1.Colors.White.keyword,
    },
    flamegraph: {
        navigation: {
            textColor: '#DFE5EF',
            buttonTextColor: '#36A2EF',
            buttonDisabledTextColor: '#515761',
            buttonBackgroundColor: '#36A2EF33',
            buttonDisabledBackgroundColor: '#34374126',
        },
        scrollbarThumb: '#DFE5EF',
        scrollbarTrack: '#343741',
        minimapFocusBorder: 'magenta',
    },
    highlighter: {
        point: {
            opacity: 0.5,
            fill: common_1.ColorVariant.Series,
            stroke: common_1.ColorVariant.None,
            strokeWidth: 0,
            radius: 5,
        },
    },
    lineAnnotation: {
        line: {
            stroke: '#98A2B3',
            strokeWidth: 1,
            opacity: 1,
        },
    },
    rectAnnotation: {
        strokeWidth: 0,
        opacity: 0.25,
        fill: '#98A2B3',
        stroke: '#98A2B3',
    },
    brush: {
        fill: colors_1.Colors.Gray.keyword,
        opacity: 0.6,
        stroke: colors_1.Colors.Transparent.keyword,
        strokeWidth: 0,
    },
};
//# sourceMappingURL=amsterdam_dark_theme.js.map