"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildPointGeometryStyles = buildPointGeometryStyles;
const color_library_wrappers_1 = require("../../../common/color_library_wrappers");
const common_1 = require("../../../utils/common");
const theme_1 = require("../../../utils/themes/theme");
function buildPointGeometryStyles(color, themePointStyle, overrides) {
    const pointStyle = (0, common_1.mergePartial)(themePointStyle, overrides);
    const opacityFn = (opacity) => opacity * pointStyle.opacity;
    return {
        fill: { color: (0, color_library_wrappers_1.overrideOpacity)((0, color_library_wrappers_1.colorToRgba)((0, common_1.getColorFromVariant)(color, pointStyle.fill)), opacityFn) },
        stroke: {
            color: (0, color_library_wrappers_1.overrideOpacity)((0, color_library_wrappers_1.colorToRgba)((0, common_1.getColorFromVariant)(color, pointStyle.stroke)), opacityFn),
            width: pointStyle.strokeWidth,
        },
        shape: pointStyle.shape ?? theme_1.PointShape.Circle,
    };
}
//# sourceMappingURL=point_style.js.map