/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

package org.elasticsearch.inference;

import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.xcontent.ToXContentObject;

import java.util.Map;

public interface ChunkingSettings extends ToXContentObject, VersionedNamedWriteable {

    ChunkingStrategy getChunkingStrategy();

    Map<String, Object> asMap();

    /**
     * @return The max chunk size specified, or null if not specified
     */
    Integer maxChunkSize();

    default void validate() {}
}
