/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc;

import java.sql.SQLException;
import java.util.List;
import org.elasticsearch.xpack.sql.jdbc.Cursor;
import org.elasticsearch.xpack.sql.jdbc.JdbcColumnInfo;
import org.elasticsearch.xpack.sql.jdbc.JdbcHttpClient;
import org.elasticsearch.xpack.sql.jdbc.RequestMeta;
import shadow.org.elasticsearch.xpack.sql.proto.core.Tuple;

class DefaultCursor
implements Cursor {
    private final JdbcHttpClient client;
    private final RequestMeta meta;
    private final List<JdbcColumnInfo> columnInfos;
    private List<List<Object>> rows;
    private final List<String> warnings;
    private int row = -1;
    private String cursor;

    DefaultCursor(JdbcHttpClient client, String cursor, List<JdbcColumnInfo> columnInfos, List<List<Object>> rows, RequestMeta meta, List<String> warnings) {
        this.client = client;
        this.meta = meta;
        this.cursor = cursor;
        this.columnInfos = columnInfos;
        this.rows = rows;
        this.warnings = warnings;
    }

    @Override
    public List<JdbcColumnInfo> columns() {
        return this.columnInfos;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.row < this.rows.size() - 1) {
            ++this.row;
            return true;
        }
        if (!this.cursor.isEmpty()) {
            Tuple<String, List<List<Object>>> nextPage = this.client.nextPage(this.cursor, this.meta);
            this.cursor = nextPage.v1();
            this.rows = nextPage.v2();
            this.row = -1;
            return this.next();
        }
        return false;
    }

    @Override
    public Object column(int column) {
        return this.rows.get(this.row).get(column);
    }

    @Override
    public int batchSize() {
        return this.rows.size();
    }

    @Override
    public void close() throws SQLException {
        if (!this.cursor.isEmpty()) {
            this.client.queryClose(this.cursor);
        }
    }

    @Override
    public List<String> warnings() {
        return this.warnings;
    }

    @Override
    public void clearWarnings() {
        this.warnings.clear();
    }
}

