/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.service;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.core.security.action.service.TokenInfo;
import org.elasticsearch.xpack.core.security.authc.service.ServiceAccountToken;

public interface ServiceAccountTokenStore {
    public void authenticate(ServiceAccountToken var1, ActionListener<StoreAuthenticationResult> var2);

    public static class StoreAuthenticationResult {
        private final boolean success;
        private final TokenInfo.TokenSource tokenSource;

        private StoreAuthenticationResult(TokenInfo.TokenSource tokenSource, boolean success) {
            this.success = success;
            this.tokenSource = tokenSource;
        }

        public static StoreAuthenticationResult successful(TokenInfo.TokenSource tokenSource) {
            return new StoreAuthenticationResult(tokenSource, true);
        }

        public static StoreAuthenticationResult failed(TokenInfo.TokenSource tokenSource) {
            return new StoreAuthenticationResult(tokenSource, false);
        }

        public static StoreAuthenticationResult fromBooleanResult(TokenInfo.TokenSource tokenSource, boolean result) {
            return result ? StoreAuthenticationResult.successful(tokenSource) : StoreAuthenticationResult.failed(tokenSource);
        }

        public boolean isSuccess() {
            return this.success;
        }

        public TokenInfo.TokenSource getTokenSource() {
            return this.tokenSource;
        }
    }
}

