/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.saml;

import java.io.IOException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.Authentication;

public final class SamlAuthenticateResponse
extends ActionResponse {
    private final String principal;
    private final String tokenString;
    private final String refreshToken;
    private final String realm;
    private final TimeValue expiresIn;
    private final Authentication authentication;

    public SamlAuthenticateResponse(Authentication authentication, String tokenString, String refreshToken, TimeValue expiresIn) {
        this.principal = authentication.getEffectiveSubject().getUser().principal();
        this.realm = authentication.getEffectiveSubject().getRealm().getName();
        this.tokenString = tokenString;
        this.refreshToken = refreshToken;
        this.expiresIn = expiresIn;
        this.authentication = authentication;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public TimeValue getExpiresIn() {
        return this.expiresIn;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.principal);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_0_0)) {
            out.writeString(this.realm);
        }
        out.writeString(this.tokenString);
        out.writeString(this.refreshToken);
        out.writeTimeValue(this.expiresIn);
        this.authentication.writeTo(out);
    }
}

