/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.CheckNotDataStreamWriteIndexStep;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.ReadOnlyStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.UpdateSettingsStep;
import org.elasticsearch.xpack.core.ilm.WaitUntilTimeSeriesEndTimePassesStep;

public class ReadOnlyAction
implements LifecycleAction {
    public static final String NAME = "readonly";
    private static final ObjectParser<ReadOnlyAction, Void> PARSER = new ObjectParser("readonly", false, ReadOnlyAction::new);
    public static final String INDEXING_COMPLETE_STEP_NAME = "set-indexing-complete";
    private static final Settings INDEXING_COMPLETE = Settings.builder().put("index.lifecycle.indexing_complete", true).build();

    public static ReadOnlyAction parse(XContentParser parser) {
        return (ReadOnlyAction)PARSER.apply(parser, null);
    }

    public ReadOnlyAction() {
    }

    public ReadOnlyAction(StreamInput in) {
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Step.StepKey checkNotWriteIndex = new Step.StepKey(phase, NAME, "check-not-write-index");
        Step.StepKey waitTimeSeriesEndTimePassesKey = new Step.StepKey(phase, NAME, "check-ts-end-time-passed");
        Step.StepKey readOnlyKey = new Step.StepKey(phase, NAME, NAME);
        Step.StepKey setIndexingCompleteStepKey = new Step.StepKey(phase, NAME, INDEXING_COMPLETE_STEP_NAME);
        CheckNotDataStreamWriteIndexStep checkNotWriteIndexStep = new CheckNotDataStreamWriteIndexStep(checkNotWriteIndex, waitTimeSeriesEndTimePassesKey);
        WaitUntilTimeSeriesEndTimePassesStep waitUntilTimeSeriesEndTimeStep = new WaitUntilTimeSeriesEndTimePassesStep(waitTimeSeriesEndTimePassesKey, readOnlyKey, Instant::now);
        ReadOnlyStep readOnlyStep = new ReadOnlyStep(readOnlyKey, setIndexingCompleteStepKey, client, true);
        UpdateSettingsStep setIndexingCompleteStep = new UpdateSettingsStep(setIndexingCompleteStepKey, nextStepKey, client, INDEXING_COMPLETE);
        return List.of(checkNotWriteIndexStep, waitUntilTimeSeriesEndTimeStep, readOnlyStep, setIndexingCompleteStep);
    }

    public int hashCode() {
        return ReadOnlyAction.class.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass() == this.getClass();
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

