/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.BranchingStep;
import org.elasticsearch.xpack.core.ilm.CheckNotDataStreamWriteIndexStep;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitUntilThresholdStep;
import org.elasticsearch.xpack.core.ilm.CopyExecutionStateStep;
import org.elasticsearch.xpack.core.ilm.CopySettingsStep;
import org.elasticsearch.xpack.core.ilm.DeleteStep;
import org.elasticsearch.xpack.core.ilm.DownsamplePrepareLifeCycleStateStep;
import org.elasticsearch.xpack.core.ilm.DownsampleStep;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.NoopStep;
import org.elasticsearch.xpack.core.ilm.ReadOnlyStep;
import org.elasticsearch.xpack.core.ilm.ReplaceDataStreamBackingIndexStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.SwapAliasesAndDeleteSourceIndexStep;
import org.elasticsearch.xpack.core.ilm.WaitForIndexColorStep;
import org.elasticsearch.xpack.core.ilm.WaitForNoFollowersStep;
import org.elasticsearch.xpack.core.ilm.WaitUntilTimeSeriesEndTimePassesStep;

public class DownsampleAction
implements LifecycleAction {
    private static final Logger logger = LogManager.getLogger(DownsampleAction.class);
    public static final String NAME = "downsample";
    public static final String DOWNSAMPLED_INDEX_PREFIX = "downsample-";
    public static final String CONDITIONAL_TIME_SERIES_CHECK_KEY = "branch-on-timeseries-check";
    public static final String CONDITIONAL_DATASTREAM_CHECK_KEY = "branch-on-datastream-check";
    public static final TimeValue DEFAULT_WAIT_TIMEOUT = new TimeValue(1L, TimeUnit.DAYS);
    private static final ParseField FIXED_INTERVAL_FIELD = new ParseField("fixed_interval", new String[0]);
    private static final ParseField WAIT_TIMEOUT_FIELD = new ParseField("wait_timeout", new String[0]);
    static final String BWC_CLEANUP_TARGET_INDEX_NAME = "cleanup-target-index";
    private static final ConstructingObjectParser<DownsampleAction, Void> PARSER = new ConstructingObjectParser("downsample", a -> new DownsampleAction((DateHistogramInterval)a[0], (TimeValue)a[1]));
    private final DateHistogramInterval fixedInterval;
    private final TimeValue waitTimeout;

    public static DownsampleAction parse(XContentParser parser) {
        return (DownsampleAction)PARSER.apply(parser, null);
    }

    public DownsampleAction(DateHistogramInterval fixedInterval, TimeValue waitTimeout) {
        if (fixedInterval == null) {
            throw new IllegalArgumentException("Parameter [" + FIXED_INTERVAL_FIELD.getPreferredName() + "] is required.");
        }
        this.fixedInterval = fixedInterval;
        this.waitTimeout = waitTimeout == null ? DEFAULT_WAIT_TIMEOUT : waitTimeout;
    }

    public DownsampleAction(StreamInput in) throws IOException {
        this(new DateHistogramInterval(in), in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_10_X) ? TimeValue.parseTimeValue((String)in.readString(), (String)WAIT_TIMEOUT_FIELD.getPreferredName()) : DEFAULT_WAIT_TIMEOUT);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.fixedInterval.writeTo(out);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_10_X)) {
            out.writeString(this.waitTimeout.getStringRep());
        } else {
            out.writeString(DEFAULT_WAIT_TIMEOUT.getStringRep());
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIXED_INTERVAL_FIELD.getPreferredName(), this.fixedInterval.toString());
        builder.field(WAIT_TIMEOUT_FIELD.getPreferredName(), this.waitTimeout.getStringRep());
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public DateHistogramInterval fixedInterval() {
        return this.fixedInterval;
    }

    public TimeValue waitTimeout() {
        return this.waitTimeout;
    }

    @Override
    public boolean isSafeAction() {
        return false;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Step.StepKey timeSeriesIndexCheckBranchKey = new Step.StepKey(phase, NAME, CONDITIONAL_TIME_SERIES_CHECK_KEY);
        Step.StepKey checkNotWriteIndex = new Step.StepKey(phase, NAME, "check-not-write-index");
        Step.StepKey waitForNoFollowerStepKey = new Step.StepKey(phase, NAME, "wait-for-shard-history-leases");
        Step.StepKey waitTimeSeriesEndTimePassesKey = new Step.StepKey(phase, NAME, "check-ts-end-time-passed");
        Step.StepKey readOnlyKey = new Step.StepKey(phase, NAME, "readonly");
        Step.StepKey cleanupDownsampleIndexKey = new Step.StepKey(phase, NAME, BWC_CLEANUP_TARGET_INDEX_NAME);
        Step.StepKey generateDownsampleIndexNameKey = new Step.StepKey(phase, NAME, "generate-downsampled-index-name");
        Step.StepKey downsampleKey = new Step.StepKey(phase, NAME, "rollup");
        Step.StepKey waitForDownsampleIndexKey = new Step.StepKey(phase, NAME, "wait-for-index-color");
        Step.StepKey copyMetadataKey = new Step.StepKey(phase, NAME, "copy-execution-state");
        Step.StepKey copyIndexLifecycleKey = new Step.StepKey(phase, NAME, "copy-settings");
        Step.StepKey dataStreamCheckBranchingKey = new Step.StepKey(phase, NAME, CONDITIONAL_DATASTREAM_CHECK_KEY);
        Step.StepKey replaceDataStreamIndexKey = new Step.StepKey(phase, NAME, "replace-datastream-backing-index");
        Step.StepKey deleteIndexKey = new Step.StepKey(phase, NAME, "delete");
        Step.StepKey swapAliasesKey = new Step.StepKey(phase, NAME, "swap-aliases");
        BranchingStep isTimeSeriesIndexBranchingStep = new BranchingStep(timeSeriesIndexCheckBranchKey, nextStepKey, checkNotWriteIndex, (index, project) -> {
            IndexMetadata indexMetadata = project.index(index);
            assert (indexMetadata != null) : "invalid cluster metadata. index [" + index.getName() + "] metadata not found";
            if (IndexSettings.MODE.get(indexMetadata.getSettings()) != IndexMode.TIME_SERIES) {
                return false;
            }
            if (index.getName().equals(DownsampleConfig.generateDownsampleIndexName((String)DOWNSAMPLED_INDEX_PREFIX, (IndexMetadata)indexMetadata, (DateHistogramInterval)this.fixedInterval))) {
                IndexMetadata.DownsampleTaskStatus downsampleStatus = (IndexMetadata.DownsampleTaskStatus)IndexMetadata.INDEX_DOWNSAMPLE_STATUS.get(indexMetadata.getSettings());
                if (downsampleStatus == IndexMetadata.DownsampleTaskStatus.UNKNOWN) {
                    logger.warn("index [{}] as part of policy [{}] cannot be downsampled at interval [{}] in phase [{}] because it has the name of the target downsample index and is itself not a downsampled index. Skipping the downsample action.", (Object)index.getName(), (Object)indexMetadata.getLifecyclePolicyName(), (Object)this.fixedInterval, (Object)phase);
                }
                return false;
            }
            return true;
        });
        CheckNotDataStreamWriteIndexStep checkNotWriteIndexStep = new CheckNotDataStreamWriteIndexStep(checkNotWriteIndex, waitForNoFollowerStepKey);
        WaitForNoFollowersStep waitForNoFollowersStep = new WaitForNoFollowersStep(waitForNoFollowerStepKey, waitTimeSeriesEndTimePassesKey, client);
        WaitUntilTimeSeriesEndTimePassesStep waitUntilTimeSeriesEndTimeStep = new WaitUntilTimeSeriesEndTimePassesStep(waitTimeSeriesEndTimePassesKey, readOnlyKey, Instant::now);
        ReadOnlyStep readOnlyStep = new ReadOnlyStep(readOnlyKey, generateDownsampleIndexNameKey, client, true);
        NoopStep cleanupDownsampleIndexStep = new NoopStep(cleanupDownsampleIndexKey, downsampleKey);
        DownsamplePrepareLifeCycleStateStep generateDownsampleIndexNameStep = new DownsamplePrepareLifeCycleStateStep(generateDownsampleIndexNameKey, downsampleKey, this.fixedInterval);
        DownsampleStep downsampleStep = new DownsampleStep(downsampleKey, waitForDownsampleIndexKey, client, this.fixedInterval, this.waitTimeout);
        ClusterStateWaitUntilThresholdStep downsampleAllocatedStep = new ClusterStateWaitUntilThresholdStep(new WaitForIndexColorStep(waitForDownsampleIndexKey, copyMetadataKey, ClusterHealthStatus.YELLOW, (indexName, lifecycleState) -> lifecycleState.downsampleIndexName()), cleanupDownsampleIndexKey);
        CopyExecutionStateStep copyExecutionStateStep = new CopyExecutionStateStep(copyMetadataKey, copyIndexLifecycleKey, (indexName, lifecycleState) -> lifecycleState.downsampleIndexName(), nextStepKey);
        CopySettingsStep copyLifecycleSettingsStep = new CopySettingsStep(copyIndexLifecycleKey, dataStreamCheckBranchingKey, (indexName, lifecycleState) -> lifecycleState.downsampleIndexName(), LifecycleSettings.LIFECYCLE_NAME_SETTING.getKey());
        BranchingStep isDataStreamBranchingStep = new BranchingStep(dataStreamCheckBranchingKey, swapAliasesKey, replaceDataStreamIndexKey, (index, project) -> {
            IndexAbstraction indexAbstraction = (IndexAbstraction)project.getIndicesLookup().get(index.getName());
            assert (indexAbstraction != null) : "invalid cluster metadata. index [" + index.getName() + "] was not found";
            return indexAbstraction.getParentDataStream() != null;
        });
        ReplaceDataStreamBackingIndexStep replaceDataStreamBackingIndex = new ReplaceDataStreamBackingIndexStep(replaceDataStreamIndexKey, deleteIndexKey, (sourceIndexName, lifecycleState) -> lifecycleState.downsampleIndexName());
        DeleteStep deleteSourceIndexStep = new DeleteStep(deleteIndexKey, nextStepKey, client);
        SwapAliasesAndDeleteSourceIndexStep swapAliasesAndDeleteSourceIndexStep = new SwapAliasesAndDeleteSourceIndexStep(swapAliasesKey, nextStepKey, client, (indexName, lifecycleState) -> lifecycleState.downsampleIndexName(), false);
        return List.of(isTimeSeriesIndexBranchingStep, checkNotWriteIndexStep, waitForNoFollowersStep, waitUntilTimeSeriesEndTimeStep, readOnlyStep, cleanupDownsampleIndexStep, generateDownsampleIndexNameStep, downsampleStep, downsampleAllocatedStep, copyExecutionStateStep, copyLifecycleSettingsStep, isDataStreamBranchingStep, replaceDataStreamBackingIndex, deleteSourceIndexStep, swapAliasesAndDeleteSourceIndexStep);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownsampleAction that = (DownsampleAction)o;
        return Objects.equals(this.fixedInterval, that.fixedInterval);
    }

    public int hashCode() {
        return Objects.hash(this.fixedInterval);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> new DateHistogramInterval(p.text()), FIXED_INTERVAL_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeValue.parseTimeValue((String)p.textOrNull(), (String)WAIT_TIMEOUT_FIELD.getPreferredName()), WAIT_TIMEOUT_FIELD, ObjectParser.ValueType.STRING);
    }
}

