/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.async;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public class GetAsyncStatusRequest
extends LegacyActionRequest {
    private final String id;
    private TimeValue keepAlive = TimeValue.MINUS_ONE;

    public GetAsyncStatusRequest(String id) {
        this.id = id;
    }

    public GetAsyncStatusRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            this.keepAlive = in.readTimeValue();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            out.writeTimeValue(this.keepAlive);
        }
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public GetAsyncStatusRequest setKeepAlive(TimeValue timeValue) {
        this.keepAlive = timeValue;
        return this;
    }

    public TimeValue getKeepAlive() {
        return this.keepAlive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GetAsyncStatusRequest request = (GetAsyncStatusRequest)((Object)o);
        return Objects.equals(this.id, request.id) && this.keepAlive.equals((Object)request.keepAlive);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.keepAlive);
    }
}

