/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;
import org.elasticsearch.compute.operator.topn.ValueExtractor;

abstract class ValueExtractorForBytesRef
implements ValueExtractor {
    private final TopNEncoder encoder;
    protected final BytesRef scratch = new BytesRef();
    protected final boolean inKey;

    static ValueExtractorForBytesRef extractorFor(TopNEncoder encoder, boolean inKey, BytesRefBlock block) {
        BytesRefVector vector = block.asVector();
        if (vector != null) {
            return new ForVector(encoder, inKey, vector);
        }
        return new ForBlock(encoder, inKey, block);
    }

    ValueExtractorForBytesRef(TopNEncoder encoder, boolean inKey) {
        this.encoder = encoder;
        this.inKey = inKey;
    }

    protected final void writeCount(BreakingBytesRefBuilder values, int count) {
        TopNEncoder.DEFAULT_UNSORTABLE.encodeVInt(count, values);
    }

    protected final void actualWriteValue(BreakingBytesRefBuilder values, BytesRef value) {
        this.encoder.encodeBytesRef(value, values);
    }

    static class ForVector
    extends ValueExtractorForBytesRef {
        private final BytesRefVector vector;

        ForVector(TopNEncoder encoder, boolean inKey, BytesRefVector vector) {
            super(encoder, inKey);
            this.vector = vector;
        }

        @Override
        public void writeValue(BreakingBytesRefBuilder values, int position) {
            this.writeCount(values, 1);
            if (this.inKey) {
                return;
            }
            this.actualWriteValue(values, this.vector.getBytesRef(position, this.scratch));
        }
    }

    static class ForBlock
    extends ValueExtractorForBytesRef {
        private final BytesRefBlock block;

        ForBlock(TopNEncoder encoder, boolean inKey, BytesRefBlock block) {
            super(encoder, inKey);
            this.block = block;
        }

        @Override
        public void writeValue(BreakingBytesRefBuilder values, int position) {
            int size = this.block.getValueCount(position);
            this.writeCount(values, size);
            if (size == 1 && this.inKey) {
                return;
            }
            int start = this.block.getFirstValueIndex(position);
            int end = start + size;
            for (int i = start; i < end; ++i) {
                this.actualWriteValue(values, this.block.getBytesRef(i, this.scratch));
            }
        }
    }
}

