/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.mvdedupe;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.operator.mvdedupe.BatchEncoder;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupe;

public class MultivalueDedupeBytesRef {
    static final int ALWAYS_COPY_MISSING = 20;
    final BytesRefBlock block;
    BytesRef[] work = new BytesRef[ArrayUtil.oversize((int)2, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
    int w;

    public MultivalueDedupeBytesRef(BytesRefBlock block) {
        this.block = block;
        this.fillWork(0, this.work.length);
    }

    public BytesRefBlock dedupeToBlockAdaptive(BlockFactory blockFactory) {
        if (this.block.mvDeduplicated()) {
            this.block.incRef();
            return this.block;
        }
        try (BytesRefBlock.Builder builder = blockFactory.newBytesRefBlockBuilder(this.block.getPositionCount());){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        builder.appendBytesRef(this.block.getBytesRef(first, this.work[0]));
                        continue block9;
                    }
                    default: {
                        if (count < 20) {
                            this.copyMissing(first, count);
                            this.writeUniquedWork(builder);
                            continue block9;
                        }
                        this.copyAndSort(first, count);
                        this.deduplicatedSortedWork(builder);
                    }
                }
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock dedupeToBlockUsingCopyAndSort(BlockFactory blockFactory) {
        if (this.block.mvDeduplicated()) {
            this.block.incRef();
            return this.block;
        }
        try (BytesRefBlock.Builder builder = blockFactory.newBytesRefBlockBuilder(this.block.getPositionCount());){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        builder.appendBytesRef(this.block.getBytesRef(first, this.work[0]));
                        continue block9;
                    }
                    default: {
                        this.copyAndSort(first, count);
                        this.deduplicatedSortedWork(builder);
                    }
                }
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock dedupeToBlockUsingCopyMissing(BlockFactory blockFactory) {
        if (this.block.mvDeduplicated()) {
            this.block.incRef();
            return this.block;
        }
        try (BytesRefBlock.Builder builder = blockFactory.newBytesRefBlockBuilder(this.block.getPositionCount());){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        builder.appendBytesRef(this.block.getBytesRef(first, this.work[0]));
                        continue block9;
                    }
                    default: {
                        this.copyMissing(first, count);
                        this.writeUniquedWork(builder);
                    }
                }
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock sortToBlock(BlockFactory blockFactory, boolean ascending) {
        try (BytesRefBlock.Builder builder = blockFactory.newBytesRefBlockBuilder(this.block.getPositionCount());){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        builder.appendBytesRef(this.block.getBytesRef(first, this.work[0]));
                        continue block9;
                    }
                    default: {
                        this.copyAndSort(first, count);
                        this.writeSortedWork(builder, ascending);
                    }
                }
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    public MultivalueDedupe.HashResult hashAdd(BlockFactory blockFactory, BytesRefHash hash) {
        try (IntBlock.Builder builder = blockFactory.newIntBlockBuilder(this.block.getPositionCount());){
            boolean sawNull = false;
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        sawNull = true;
                        builder.appendInt(0);
                        continue block9;
                    }
                    case 1: {
                        BytesRef v = this.block.getBytesRef(first, this.work[0]);
                        this.hashAdd(builder, hash, v);
                        continue block9;
                    }
                    default: {
                        if (count < 20) {
                            this.copyMissing(first, count);
                            this.hashAddUniquedWork(hash, builder);
                            continue block9;
                        }
                        this.copyAndSort(first, count);
                        this.hashAddSortedWork(hash, builder);
                    }
                }
            }
            MultivalueDedupe.HashResult hashResult = new MultivalueDedupe.HashResult(builder.build(), sawNull);
            return hashResult;
        }
    }

    public IntBlock hashLookup(BlockFactory blockFactory, BytesRefHash hash) {
        try (IntBlock.Builder builder = blockFactory.newIntBlockBuilder(this.block.getPositionCount());){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        builder.appendInt(0);
                        continue block9;
                    }
                    case 1: {
                        BytesRef v = this.block.getBytesRef(first, this.work[0]);
                        this.hashLookupSingle(builder, hash, v);
                        continue block9;
                    }
                    default: {
                        if (count < 20) {
                            this.copyMissing(first, count);
                            this.hashLookupUniquedWork(hash, builder);
                            continue block9;
                        }
                        this.copyAndSort(first, count);
                        this.hashLookupSortedWork(hash, builder);
                    }
                }
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    public BatchEncoder batchEncoder(int batchSize) {
        this.block.incRef();
        return new BatchEncoder.BytesRefs(batchSize){

            @Override
            protected void readNextBatch() {
                int position = this.firstPosition();
                if (MultivalueDedupeBytesRef.this.w > 0) {
                    this.ensureCapacity(this.workSize(), MultivalueDedupeBytesRef.this.w);
                    this.startPosition();
                    MultivalueDedupeBytesRef.this.encodeUniquedWork(this);
                    this.endPosition();
                    ++position;
                }
                while (position < MultivalueDedupeBytesRef.this.block.getPositionCount()) {
                    int count = MultivalueDedupeBytesRef.this.block.getValueCount(position);
                    int first = MultivalueDedupeBytesRef.this.block.getFirstValueIndex(position);
                    switch (count) {
                        case 0: {
                            this.encodeNull();
                            break;
                        }
                        case 1: {
                            BytesRef v = MultivalueDedupeBytesRef.this.block.getBytesRef(first, MultivalueDedupeBytesRef.this.work[0]);
                            if (this.hasCapacity(v.length, 1)) {
                                this.startPosition();
                                this.encode(v);
                                this.endPosition();
                                break;
                            }
                            MultivalueDedupeBytesRef.this.work[0] = v;
                            MultivalueDedupeBytesRef.this.w = 1;
                            return;
                        }
                        default: {
                            if (count < 20) {
                                MultivalueDedupeBytesRef.this.copyMissing(first, count);
                            } else {
                                MultivalueDedupeBytesRef.this.copyAndSort(first, count);
                                MultivalueDedupeBytesRef.this.convertSortedWorkToUnique();
                            }
                            if (this.hasCapacity(this.workSize(), MultivalueDedupeBytesRef.this.w)) {
                                this.startPosition();
                                MultivalueDedupeBytesRef.this.encodeUniquedWork(this);
                                this.endPosition();
                                break;
                            }
                            return;
                        }
                    }
                    ++position;
                }
            }

            private int workSize() {
                int size = 0;
                for (int i = 0; i < MultivalueDedupeBytesRef.this.w; ++i) {
                    size += MultivalueDedupeBytesRef.this.work[i].length;
                }
                return size;
            }

            public void close() {
                MultivalueDedupeBytesRef.this.block.decRef();
            }
        };
    }

    void copyAndSort(int first, int count) {
        this.grow(count);
        int end = first + count;
        this.w = 0;
        for (int i = first; i < end; ++i) {
            this.work[this.w] = this.block.getBytesRef(i, this.work[this.w]);
            ++this.w;
        }
        Arrays.sort(this.work, 0, this.w);
    }

    void copyMissing(int first, int count) {
        this.grow(count);
        int end = first + count;
        this.work[0] = this.block.getBytesRef(first, this.work[0]);
        this.w = 1;
        block0: for (int i = first + 1; i < end; ++i) {
            BytesRef v = this.block.getBytesRef(i, this.work[this.w]);
            for (int j = 0; j < this.w; ++j) {
                if (v.equals((Object)this.work[j])) continue block0;
            }
            this.work[this.w++] = v;
        }
    }

    private void writeUniquedWork(BytesRefBlock.Builder builder) {
        if (this.w == 1) {
            builder.appendBytesRef(this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        for (int i = 0; i < this.w; ++i) {
            builder.appendBytesRef(this.work[i]);
        }
        builder.endPositionEntry();
    }

    private void deduplicatedSortedWork(BytesRefBlock.Builder builder) {
        builder.beginPositionEntry();
        BytesRef prev = this.work[0];
        builder.appendBytesRef(prev);
        for (int i = 1; i < this.w; ++i) {
            if (prev.equals((Object)this.work[i])) continue;
            prev = this.work[i];
            builder.appendBytesRef(prev);
        }
        builder.endPositionEntry();
    }

    private void writeSortedWork(BytesRefBlock.Builder builder, boolean ascending) {
        builder.beginPositionEntry();
        for (int i = 0; i < this.w; ++i) {
            if (ascending) {
                builder.appendBytesRef(this.work[i]);
                continue;
            }
            builder.appendBytesRef(this.work[this.w - i - 1]);
        }
        builder.endPositionEntry();
    }

    private void hashAddUniquedWork(BytesRefHash hash, IntBlock.Builder builder) {
        if (this.w == 1) {
            this.hashAdd(builder, hash, this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        for (int i = 0; i < this.w; ++i) {
            this.hashAdd(builder, hash, this.work[i]);
        }
        builder.endPositionEntry();
    }

    private void hashAddSortedWork(BytesRefHash hash, IntBlock.Builder builder) {
        if (this.w == 1) {
            this.hashAdd(builder, hash, this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        BytesRef prev = this.work[0];
        this.hashAdd(builder, hash, prev);
        for (int i = 1; i < this.w; ++i) {
            if (MultivalueDedupeBytesRef.valuesEqual(prev, this.work[i])) continue;
            prev = this.work[i];
            this.hashAdd(builder, hash, prev);
        }
        builder.endPositionEntry();
    }

    private void hashLookupUniquedWork(BytesRefHash hash, IntBlock.Builder builder) {
        long nextLookup;
        if (this.w == 1) {
            this.hashLookupSingle(builder, hash, this.work[0]);
            return;
        }
        int i = 1;
        long firstLookup = this.hashLookup(hash, this.work[0]);
        while (firstLookup < 0L) {
            if (i >= this.w) {
                builder.appendNull();
                return;
            }
            firstLookup = this.hashLookup(hash, this.work[i]);
            ++i;
        }
        boolean foundSecond = false;
        while (i < this.w) {
            nextLookup = this.hashLookup(hash, this.work[i]);
            if (nextLookup >= 0L) {
                builder.beginPositionEntry();
                this.appendFound(builder, firstLookup);
                this.appendFound(builder, nextLookup);
                ++i;
                foundSecond = true;
                break;
            }
            ++i;
        }
        if (!foundSecond) {
            this.appendFound(builder, firstLookup);
            return;
        }
        while (i < this.w) {
            nextLookup = this.hashLookup(hash, this.work[i]);
            if (nextLookup >= 0L) {
                this.appendFound(builder, nextLookup);
            }
            ++i;
        }
        builder.endPositionEntry();
    }

    private void hashLookupSortedWork(BytesRefHash hash, IntBlock.Builder builder) {
        long nextLookup;
        if (this.w == 1) {
            this.hashLookupSingle(builder, hash, this.work[0]);
            return;
        }
        int i = 1;
        BytesRef prev = this.work[0];
        long firstLookup = this.hashLookup(hash, prev);
        while (firstLookup < 0L) {
            if (i >= this.w) {
                builder.appendNull();
                return;
            }
            prev = this.work[i];
            firstLookup = this.hashLookup(hash, prev);
            ++i;
        }
        boolean foundSecond = false;
        while (i < this.w) {
            if (!MultivalueDedupeBytesRef.valuesEqual(prev, this.work[i]) && (nextLookup = this.hashLookup(hash, this.work[i])) >= 0L) {
                prev = this.work[i];
                builder.beginPositionEntry();
                this.appendFound(builder, firstLookup);
                this.appendFound(builder, nextLookup);
                ++i;
                foundSecond = true;
                break;
            }
            ++i;
        }
        if (!foundSecond) {
            this.appendFound(builder, firstLookup);
            return;
        }
        while (i < this.w) {
            if (!MultivalueDedupeBytesRef.valuesEqual(prev, this.work[i]) && (nextLookup = this.hashLookup(hash, this.work[i])) >= 0L) {
                prev = this.work[i];
                this.appendFound(builder, nextLookup);
            }
            ++i;
        }
        builder.endPositionEntry();
    }

    private void encodeUniquedWork(BatchEncoder.BytesRefs encoder) {
        for (int i = 0; i < this.w; ++i) {
            encoder.encode(this.work[i]);
        }
    }

    private void convertSortedWorkToUnique() {
        BytesRef prev = this.work[0];
        int end = this.w;
        this.w = 1;
        for (int i = 1; i < end; ++i) {
            if (MultivalueDedupeBytesRef.valuesEqual(prev, this.work[i])) continue;
            prev = this.work[i];
            this.work[this.w].bytes = prev.bytes;
            this.work[this.w].offset = prev.offset;
            this.work[this.w].length = prev.length;
            ++this.w;
        }
    }

    private void grow(int size) {
        int prev = this.work.length;
        this.work = (BytesRef[])ArrayUtil.grow((Object[])this.work, (int)size);
        this.fillWork(prev, this.work.length);
    }

    private void fillWork(int from, int to) {
        for (int i = from; i < to; ++i) {
            this.work[i] = new BytesRef();
        }
    }

    private void hashAdd(IntBlock.Builder builder, BytesRefHash hash, BytesRef v) {
        this.appendFound(builder, hash.add(v));
    }

    private long hashLookup(BytesRefHash hash, BytesRef v) {
        return hash.find(v);
    }

    private void hashLookupSingle(IntBlock.Builder builder, BytesRefHash hash, BytesRef v) {
        long found = this.hashLookup(hash, v);
        if (found >= 0L) {
            this.appendFound(builder, found);
        } else {
            builder.appendNull();
        }
    }

    private void appendFound(IntBlock.Builder builder, long found) {
        builder.appendInt(Math.toIntExact(BlockHash.hashOrdToGroupNullReserved(found)));
    }

    private static boolean valuesEqual(BytesRef lhs, BytesRef rhs) {
        return lhs.equals((Object)rhs);
    }
}

