/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene.read;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.BlockLoader;

public final class SortedSetOrdinalsBuilder
implements BlockLoader.SortedSetOrdinalsBuilder,
Releasable,
Block.Builder {
    private final BlockFactory blockFactory;
    private final SortedSetDocValues docValues;
    private int minOrd = Integer.MAX_VALUE;
    private int maxOrd = Integer.MIN_VALUE;
    private int totalValueCount;
    private final IntBlock.Builder ordsBuilder;

    public SortedSetOrdinalsBuilder(BlockFactory blockFactory, SortedSetDocValues docValues, int count) {
        this.blockFactory = blockFactory;
        this.docValues = docValues;
        this.ordsBuilder = blockFactory.newIntBlockBuilder(count).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
    }

    @Override
    public SortedSetOrdinalsBuilder appendNull() {
        this.ordsBuilder.appendNull();
        return this;
    }

    public SortedSetOrdinalsBuilder appendOrd(int ord) {
        this.minOrd = Math.min(this.minOrd, ord);
        this.maxOrd = Math.max(this.maxOrd, ord);
        this.ordsBuilder.appendInt(ord);
        ++this.totalValueCount;
        return this;
    }

    @Override
    public SortedSetOrdinalsBuilder beginPositionEntry() {
        this.ordsBuilder.beginPositionEntry();
        return this;
    }

    @Override
    public SortedSetOrdinalsBuilder endPositionEntry() {
        this.ordsBuilder.endPositionEntry();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BytesRefBlock buildBlock(IntBlock ordinals) {
        OrdinalBytesRefBlock ordinalBytesRefBlock;
        int numOrds = this.maxOrd - this.minOrd + 1;
        long breakerSize = SortedSetOrdinalsBuilder.arraySize(numOrds);
        this.blockFactory.adjustBreaker(breakerSize);
        BytesRefVector dict = null;
        IntBlock mappedOrds = null;
        try {
            int[] newOrds = new int[numOrds];
            Arrays.fill(newOrds, -1);
            for (int p = 0; p < ordinals.getPositionCount(); ++p) {
                int count = ordinals.getValueCount(p);
                if (count <= 0) continue;
                int first = ordinals.getFirstValueIndex(p);
                for (int i = 0; i < count; ++i) {
                    int oldOrd = ordinals.getInt(first + i);
                    newOrds[oldOrd - this.minOrd] = 0;
                }
            }
            int nextOrd = -1;
            try (BytesRefVector.Builder dictBuilder = this.blockFactory.newBytesRefVectorBuilder(Math.min(newOrds.length, this.totalValueCount));){
                for (int i = 0; i < newOrds.length; ++i) {
                    if (newOrds[i] == -1) continue;
                    newOrds[i] = ++nextOrd;
                    dictBuilder.appendBytesRef(this.docValues.lookupOrd((long)(i + this.minOrd)));
                }
                dict = dictBuilder.build();
            }
            catch (IOException e) {
                throw new UncheckedIOException("error resolving ordinals", e);
            }
            mappedOrds = this.remapOrdinals(ordinals, newOrds, this.minOrd);
            OrdinalBytesRefBlock result = new OrdinalBytesRefBlock(mappedOrds, dict);
            dict = null;
            mappedOrds = null;
            ordinalBytesRefBlock = result;
        }
        catch (Throwable throwable) {
            Releasables.close((Releasable[])new Releasable[]{() -> this.blockFactory.adjustBreaker(-breakerSize), mappedOrds, dict});
            throw throwable;
        }
        Releasables.close((Releasable[])new Releasable[]{() -> this.blockFactory.adjustBreaker(-breakerSize), mappedOrds, dict});
        return ordinalBytesRefBlock;
    }

    private IntBlock remapOrdinals(IntBlock ordinals, int[] newOrds, int shiftOrd) {
        try (IntBlock.Builder builder = this.blockFactory.newIntBlockBuilder(this.totalValueCount);){
            block9: for (int p = 0; p < ordinals.getPositionCount(); ++p) {
                int valueCount = ordinals.getValueCount(p);
                switch (valueCount) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        int ord = ordinals.getInt(ordinals.getFirstValueIndex(p));
                        builder.appendInt(newOrds[ord - shiftOrd]);
                        continue block9;
                    }
                    default: {
                        int first = ordinals.getFirstValueIndex(p);
                        builder.beginPositionEntry();
                        int last = first + valueCount;
                        for (int i = first; i < last; ++i) {
                            int ord = ordinals.getInt(i);
                            builder.appendInt(newOrds[ord - shiftOrd]);
                        }
                        builder.endPositionEntry();
                    }
                }
            }
            builder.mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    @Override
    public long estimatedBytes() {
        int numOrds = this.minOrd <= this.maxOrd ? this.maxOrd - this.minOrd + 1 : 0;
        return (long)this.totalValueCount * 4L + (long)Math.min(numOrds, this.totalValueCount) * 20L;
    }

    @Override
    public BytesRefBlock build() {
        try (IntBlock ordinals = this.ordsBuilder.build();){
            if (ordinals.areAllValuesNull()) {
                BytesRefBlock bytesRefBlock = (BytesRefBlock)this.blockFactory.newConstantNullBlock(ordinals.getPositionCount());
                return bytesRefBlock;
            }
            BytesRefBlock bytesRefBlock = this.buildBlock(ordinals);
            return bytesRefBlock;
        }
    }

    public void close() {
        this.ordsBuilder.close();
    }

    @Override
    public Block.Builder copyFrom(Block block, int beginInclusive, int endExclusive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block.Builder mvOrdering(Block.MvOrdering mvOrdering) {
        throw new UnsupportedOperationException();
    }

    private static long arraySize(int ordsCount) {
        return (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)ordsCount * 4L;
    }
}

