/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.common.util.LongLongHash;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

class ValuesDoubleAggregator {
    ValuesDoubleAggregator() {
    }

    public static SingleState initSingle(BigArrays bigArrays) {
        return new SingleState(bigArrays);
    }

    public static void combine(SingleState state, double v) {
        state.values.add(Double.doubleToLongBits(v));
    }

    public static void combineIntermediate(SingleState state, DoubleBlock values) {
        int start = values.getFirstValueIndex(0);
        int end = start + values.getValueCount(0);
        for (int i = start; i < end; ++i) {
            ValuesDoubleAggregator.combine(state, values.getDouble(i));
        }
    }

    public static Block evaluateFinal(SingleState state, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory());
    }

    public static GroupingState initGrouping(DriverContext driverContext) {
        return new GroupingState(driverContext);
    }

    public static void combine(GroupingState state, int groupId, double v) {
        state.addValue(groupId, v);
    }

    public static void combineIntermediate(GroupingState state, int groupId, DoubleBlock values, int valuesPosition) {
        int start = values.getFirstValueIndex(valuesPosition);
        int end = start + values.getValueCount(valuesPosition);
        for (int i = start; i < end; ++i) {
            state.addValue(groupId, values.getDouble(i));
        }
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        return state.toBlock(ctx.blockFactory(), selected);
    }

    public static class SingleState
    implements AggregatorState {
        private final LongHash values;

        private SingleState(BigArrays bigArrays) {
            this.values = new LongHash(1L, bigArrays);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory());
        }

        Block toBlock(BlockFactory blockFactory) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(1);
            }
            if (this.values.size() == 1L) {
                return blockFactory.newConstantDoubleBlockWith(Double.longBitsToDouble(this.values.get(0L)), 1);
            }
            try (DoubleBlock.Builder builder = blockFactory.newDoubleBlockBuilder((int)this.values.size());){
                builder.beginPositionEntry();
                int id = 0;
                while ((long)id < this.values.size()) {
                    builder.appendDouble(Double.longBitsToDouble(this.values.get((long)id)));
                    ++id;
                }
                builder.endPositionEntry();
                DoubleBlock doubleBlock = builder.build();
                return doubleBlock;
            }
        }

        public void close() {
            this.values.close();
        }
    }

    public static class GroupingState
    implements GroupingAggregatorState {
        private final BlockFactory blockFactory;
        DoubleArray firstValues;
        private BitArray seen;
        private int maxGroupId = -1;
        private final NextValues nextValues;

        private GroupingState(DriverContext driverContext) {
            this.blockFactory = driverContext.blockFactory();
            boolean success = false;
            try {
                this.firstValues = driverContext.bigArrays().newDoubleArray(1L, false);
                this.nextValues = new NextValues(driverContext.blockFactory());
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory(), selected);
        }

        void addValue(int groupId, double v) {
            if (groupId > this.maxGroupId) {
                this.firstValues = this.blockFactory.bigArrays().grow(this.firstValues, (long)(groupId + 1));
                this.firstValues.set((long)groupId, v);
                if (this.seen == null && groupId > this.maxGroupId + 1) {
                    this.seen = new BitArray((long)(groupId + 1), this.blockFactory.bigArrays());
                    this.seen.fill(0L, (long)(this.maxGroupId + 1), true);
                }
                this.trackGroupId(groupId);
                this.maxGroupId = groupId;
            } else if (!this.hasValue(groupId)) {
                this.firstValues.set((long)groupId, v);
                this.trackGroupId(groupId);
            } else if (this.firstValues.get((long)groupId) != v) {
                this.nextValues.addValue(groupId, v);
            }
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seen) {
        }

        private void trackGroupId(int groupId) {
            if (this.seen != null) {
                this.seen.set((long)groupId);
            }
        }

        private boolean hasValue(int groupId) {
            return this.seen == null || this.seen.get((long)groupId);
        }

        Block toBlock(BlockFactory blockFactory, IntVector selected) {
            this.nextValues.prepareForEmitting(selected);
            return this.buildOutputBlock(blockFactory, selected);
        }

        Block buildOutputBlock(BlockFactory blockFactory, IntVector selected) {
            int[] nextValueCounts = this.nextValues.selectedCounts;
            try (DoubleBlock.Builder builder = blockFactory.newDoubleBlockBuilder(selected.getPositionCount());){
                int nextValuesStart = 0;
                for (int s = 0; s < selected.getPositionCount(); ++s) {
                    int nextValuesEnd;
                    int group = selected.getInt(s);
                    if (group > this.maxGroupId || !this.hasValue(group)) {
                        builder.appendNull();
                        continue;
                    }
                    double firstValue = this.firstValues.get((long)group);
                    int n = nextValuesEnd = nextValueCounts != null ? nextValueCounts[group] : nextValuesStart;
                    if (nextValuesEnd == nextValuesStart) {
                        builder.appendDouble(firstValue);
                        continue;
                    }
                    builder.beginPositionEntry();
                    builder.appendDouble(firstValue);
                    for (int i = nextValuesStart; i < nextValuesEnd; ++i) {
                        double nextValue = this.nextValues.getValue(i);
                        builder.appendDouble(nextValue);
                    }
                    builder.endPositionEntry();
                    nextValuesStart = nextValuesEnd;
                }
                DoubleBlock doubleBlock = builder.build();
                return doubleBlock;
            }
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.seen, this.firstValues, this.nextValues});
        }
    }

    private static class NextValues
    implements Releasable {
        private final BlockFactory blockFactory;
        private final LongLongHash hashes;
        private int[] selectedCounts = null;
        private int[] ids = null;
        private long extraMemoryUsed = 0L;

        private NextValues(BlockFactory blockFactory) {
            this.blockFactory = blockFactory;
            this.hashes = new LongLongHash(1L, blockFactory.bigArrays());
        }

        void addValue(int groupId, double v) {
            this.hashes.add((long)groupId, Double.doubleToLongBits(v));
        }

        double getValue(int index) {
            return Double.longBitsToDouble(this.hashes.getKey2((long)this.ids[index]));
        }

        private void reserveBytesForIntArray(long numElements) {
            long adjust = RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + numElements * 4L));
            this.blockFactory.adjustBreaker(adjust);
            this.extraMemoryUsed += adjust;
        }

        private void prepareForEmitting(IntVector selected) {
            int group;
            if (this.hashes.size() == 0L) {
                return;
            }
            int selectedCountsLen = selected.max() + 1;
            this.reserveBytesForIntArray(selectedCountsLen);
            this.selectedCounts = new int[selectedCountsLen];
            int id = 0;
            while ((long)id < this.hashes.size()) {
                int group2 = (int)this.hashes.getKey1((long)id);
                if (group2 < this.selectedCounts.length) {
                    int n = group2;
                    this.selectedCounts[n] = this.selectedCounts[n] - 1;
                }
                ++id;
            }
            int total = 0;
            for (int s = 0; s < selected.getPositionCount(); ++s) {
                group = selected.getInt(s);
                int count = -this.selectedCounts[group];
                this.selectedCounts[group] = total;
                total += count;
            }
            this.reserveBytesForIntArray(total);
            this.ids = new int[total];
            int id2 = 0;
            while ((long)id2 < this.hashes.size()) {
                int n = group = (int)this.hashes.getKey1((long)id2);
                int n2 = this.selectedCounts[n];
                this.selectedCounts[n] = n2 + 1;
                this.ids[n2] = id2++;
            }
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.hashes, () -> this.blockFactory.adjustBreaker(-this.extraMemoryUsed)});
        }
    }
}

