/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.type;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DateEsField;
import org.elasticsearch.xpack.esql.core.type.InvalidMappedField;
import org.elasticsearch.xpack.esql.core.type.KeywordEsField;
import org.elasticsearch.xpack.esql.core.type.MultiTypeEsField;
import org.elasticsearch.xpack.esql.core.type.PotentiallyUnmappedKeywordEsField;
import org.elasticsearch.xpack.esql.core.type.TextEsField;
import org.elasticsearch.xpack.esql.core.type.UnsupportedEsField;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.core.util.PlanStreamOutput;

public class EsField
implements Writeable {
    private static final TransportVersion ESQL_SERIALIZE_TIMESERIES_FIELD_TYPE = TransportVersion.fromName((String)"esql_serialize_timeseries_field_type");
    private static Map<String, Writeable.Reader<? extends EsField>> readers = Map.ofEntries(Map.entry("DateEsField", DateEsField::new), Map.entry("EsField", EsField::new), Map.entry("InvalidMappedField", InvalidMappedField::new), Map.entry("KeywordEsField", KeywordEsField::new), Map.entry("MultiTypeEsField", MultiTypeEsField::new), Map.entry("PotentiallyUnmappedKeywordEsField", PotentiallyUnmappedKeywordEsField::new), Map.entry("TextEsField", TextEsField::new), Map.entry("UnsupportedEsField", UnsupportedEsField::new));
    private final DataType esDataType;
    private final boolean aggregatable;
    private final Map<String, EsField> properties;
    private final String name;
    private final boolean isAlias;
    private final TimeSeriesFieldType timeSeriesFieldType;

    public static Writeable.Reader<? extends EsField> getReader(String name) {
        Writeable.Reader<? extends EsField> result = readers.get(name);
        if (result == null) {
            throw new IllegalArgumentException("Invalid EsField type [" + name + "]");
        }
        return result;
    }

    public EsField(String name, DataType esDataType, Map<String, EsField> properties, boolean aggregatable, TimeSeriesFieldType timeSeriesFieldType) {
        this(name, esDataType, properties, aggregatable, false, timeSeriesFieldType);
    }

    public EsField(String name, DataType esDataType, Map<String, EsField> properties, boolean aggregatable, boolean isAlias, TimeSeriesFieldType timeSeriesFieldType) {
        this.name = name;
        this.esDataType = esDataType;
        this.aggregatable = aggregatable;
        this.properties = properties;
        this.isAlias = isAlias;
        this.timeSeriesFieldType = timeSeriesFieldType;
    }

    public EsField(StreamInput in) throws IOException {
        this.name = ((PlanStreamInput)in).readCachedString();
        this.esDataType = DataType.readFrom(in);
        this.properties = in.readImmutableMap(EsField::readFrom);
        this.aggregatable = in.readBoolean();
        this.isAlias = in.readBoolean();
        this.timeSeriesFieldType = EsField.readTimeSeriesFieldType(in);
    }

    public static <A extends EsField> A readFrom(StreamInput in) throws IOException {
        return ((PlanStreamInput)in).readEsFieldWithCache();
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (((PlanStreamOutput)out).writeEsFieldCacheHeader(this)) {
            this.writeContent(out);
        }
    }

    public void writeContent(StreamOutput out) throws IOException {
        ((PlanStreamOutput)out).writeCachedString(this.name);
        this.esDataType.writeTo(out);
        out.writeMap(this.properties, (o, x) -> x.writeTo(out));
        out.writeBoolean(this.aggregatable);
        out.writeBoolean(this.isAlias);
        this.writeTimeSeriesFieldType(out);
    }

    protected void writeTimeSeriesFieldType(StreamOutput out) throws IOException {
        if (out.getTransportVersion().supports(ESQL_SERIALIZE_TIMESERIES_FIELD_TYPE)) {
            this.timeSeriesFieldType.writeTo(out);
        }
    }

    protected static TimeSeriesFieldType readTimeSeriesFieldType(StreamInput in) throws IOException {
        if (in.getTransportVersion().supports(ESQL_SERIALIZE_TIMESERIES_FIELD_TYPE)) {
            return TimeSeriesFieldType.readFromStream(in);
        }
        return TimeSeriesFieldType.UNKNOWN;
    }

    public String getWriteableName() {
        return "EsField";
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.esDataType;
    }

    public boolean isAggregatable() {
        return this.aggregatable;
    }

    @Nullable
    public Map<String, EsField> getProperties() {
        return this.properties;
    }

    public boolean isAlias() {
        return this.isAlias;
    }

    public EsField getExactField() {
        return this;
    }

    public Exact getExactInfo() {
        return Exact.EXACT_FIELD;
    }

    public TimeSeriesFieldType getTimeSeriesFieldType() {
        return this.timeSeriesFieldType;
    }

    public String toString() {
        return this.name + "@" + this.esDataType.typeName() + "=" + String.valueOf(this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EsField field = (EsField)o;
        return this.aggregatable == field.aggregatable && this.isAlias == field.isAlias && this.esDataType == field.esDataType && Objects.equals(this.name, field.name) && Objects.equals(this.properties, field.properties) && Objects.equals((Object)this.timeSeriesFieldType, (Object)field.timeSeriesFieldType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.esDataType, this.aggregatable, this.properties, this.name, this.isAlias, this.timeSeriesFieldType});
    }

    public static abstract sealed class TimeSeriesFieldType
    extends Enum<TimeSeriesFieldType>
    implements Writeable {
        public static final /* enum */ TimeSeriesFieldType UNKNOWN = new TimeSeriesFieldType(0){

            @Override
            public TimeSeriesFieldType merge(TimeSeriesFieldType other) {
                return other;
            }
        };
        public static final /* enum */ TimeSeriesFieldType NONE = new TimeSeriesFieldType(1){

            @Override
            public TimeSeriesFieldType merge(TimeSeriesFieldType other) {
                return other;
            }
        };
        public static final /* enum */ TimeSeriesFieldType METRIC = new TimeSeriesFieldType(2){

            @Override
            public TimeSeriesFieldType merge(TimeSeriesFieldType other) {
                if (other != DIMENSION) {
                    return METRIC;
                }
                throw new IllegalStateException("Time Series Metadata conflict.  Cannot merge [" + String.valueOf((Object)other) + "] with [METRIC].");
            }
        };
        public static final /* enum */ TimeSeriesFieldType DIMENSION = new TimeSeriesFieldType(3){

            @Override
            public TimeSeriesFieldType merge(TimeSeriesFieldType other) {
                if (other != METRIC) {
                    return DIMENSION;
                }
                throw new IllegalStateException("Time Series Metadata conflict.  Cannot merge [" + String.valueOf((Object)other) + "] with [DIMENSION].");
            }
        };
        private final int id;
        private static final /* synthetic */ TimeSeriesFieldType[] $VALUES;

        public static TimeSeriesFieldType[] values() {
            return (TimeSeriesFieldType[])$VALUES.clone();
        }

        public static TimeSeriesFieldType valueOf(String name) {
            return Enum.valueOf(TimeSeriesFieldType.class, name);
        }

        private TimeSeriesFieldType(int id) {
            this.id = id;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.id);
        }

        public static TimeSeriesFieldType readFromStream(StreamInput in) throws IOException {
            int id = in.readVInt();
            return switch (id) {
                case 0 -> UNKNOWN;
                case 1 -> NONE;
                case 2 -> METRIC;
                case 3 -> DIMENSION;
                default -> throw new IOException("Unexpected value for TimeSeriesFieldType: " + id);
            };
        }

        public static TimeSeriesFieldType fromIndexFieldCapabilities(IndexFieldCapabilities capabilities) {
            if (capabilities.isDimension()) {
                assert (capabilities.metricType() == null);
                return DIMENSION;
            }
            if (capabilities.metricType() != null) {
                return METRIC;
            }
            return NONE;
        }

        public abstract TimeSeriesFieldType merge(TimeSeriesFieldType var1);

        private static /* synthetic */ TimeSeriesFieldType[] $values() {
            return new TimeSeriesFieldType[]{UNKNOWN, NONE, METRIC, DIMENSION};
        }

        static {
            $VALUES = TimeSeriesFieldType.$values();
        }
    }

    public static final class Exact {
        private static Exact EXACT_FIELD = new Exact(true, null);
        private boolean hasExact;
        private String errorMsg;

        public Exact(boolean hasExact, String errorMsg) {
            this.hasExact = hasExact;
            this.errorMsg = errorMsg;
        }

        public boolean hasExact() {
            return this.hasExact;
        }

        public String errorMsg() {
            return this.errorMsg;
        }
    }
}

