/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate.regex;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.AbstractStringPattern;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.WildcardPattern;

public class WildcardPatternList
extends AbstractStringPattern
implements Writeable {
    public static final String NAME = "WildcardPatternList";
    private final List<WildcardPattern> patternList;

    public WildcardPatternList(List<WildcardPattern> patterns) {
        this.patternList = patterns;
    }

    public WildcardPatternList(StreamInput in) throws IOException {
        this(in.readCollectionAsList(WildcardPattern::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.patternList, (o, pattern) -> pattern.writeTo(o));
    }

    public List<WildcardPattern> patternList() {
        return this.patternList;
    }

    @Override
    public Automaton createAutomaton(boolean ignoreCase) {
        List<Automaton> automatonList = this.patternList.stream().map(x -> x.createAutomaton(ignoreCase)).toList();
        Automaton result = Operations.union(automatonList);
        return Operations.determinize((Automaton)result, (int)10000);
    }

    @Override
    public String asJavaRegex() {
        return this.patternList.stream().map(WildcardPattern::asJavaRegex).collect(Collectors.joining("|"));
    }

    @Override
    public String pattern() {
        if (this.patternList.isEmpty()) {
            return "";
        }
        if (this.patternList.size() == 1) {
            return this.patternList.getFirst().pattern();
        }
        return "(\"" + this.patternList.stream().map(WildcardPattern::pattern).collect(Collectors.joining("\", \"")) + "\")";
    }

    public int hashCode() {
        return Objects.hash(this.patternList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WildcardPatternList other = (WildcardPatternList)obj;
        return this.patternList.equals(other.patternList);
    }
}

