/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.NodeSelector;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.test.rest.Stash;
import org.elasticsearch.test.rest.TestFeatureService;
import org.elasticsearch.test.rest.yaml.ClientYamlTestCandidate;
import org.elasticsearch.test.rest.yaml.ClientYamlTestClient;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponse;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponseException;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestApi;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;

public class ClientYamlTestExecutionContext {
    private static final Logger logger = LogManager.getLogger(ClientYamlTestExecutionContext.class);
    private static final XContentType[] STREAMING_CONTENT_TYPES = new XContentType[]{XContentType.JSON, XContentType.SMILE};
    private final Stash stash = new Stash();
    private final ClientYamlTestClient clientYamlTestClient;
    private final ClientYamlTestCandidate clientYamlTestCandidate;
    private ClientYamlTestResponse response;
    private final Set<String> nodesVersions;
    private final Set<String> osSet;
    private final TestFeatureService testFeatureService;
    private final boolean randomizeContentType;
    private final BiPredicate<ClientYamlSuiteRestApi, ClientYamlSuiteRestApi.Path> pathPredicate;

    public ClientYamlTestExecutionContext(ClientYamlTestCandidate clientYamlTestCandidate, ClientYamlTestClient clientYamlTestClient, boolean randomizeContentType, Set<String> nodesVersions, TestFeatureService testFeatureService, Set<String> osSet) {
        this(clientYamlTestCandidate, clientYamlTestClient, randomizeContentType, nodesVersions, testFeatureService, osSet, (ignoreApi, ignorePath) -> true);
    }

    public ClientYamlTestExecutionContext(ClientYamlTestCandidate clientYamlTestCandidate, ClientYamlTestClient clientYamlTestClient, boolean randomizeContentType, Set<String> nodesVersions, TestFeatureService testFeatureService, Set<String> osSet, BiPredicate<ClientYamlSuiteRestApi, ClientYamlSuiteRestApi.Path> pathPredicate) {
        this.clientYamlTestClient = clientYamlTestClient;
        this.clientYamlTestCandidate = clientYamlTestCandidate;
        this.randomizeContentType = randomizeContentType;
        this.nodesVersions = nodesVersions;
        this.testFeatureService = testFeatureService;
        this.osSet = osSet;
        this.pathPredicate = pathPredicate;
    }

    public ClientYamlTestResponse callApi(String apiName, Map<String, String> params, List<Map<String, Object>> bodies, Map<String, String> headers) throws IOException {
        return this.callApi(apiName, params, bodies, headers, NodeSelector.ANY);
    }

    public ClientYamlTestResponse callApi(String apiName, Map<String, String> params, List<Map<String, Object>> bodies, Map<String, String> headers, NodeSelector nodeSelector) throws IOException {
        Object responseBody;
        ClientYamlTestResponse clientYamlTestResponse;
        HashMap<String, String> requestParams = new HashMap<String, String>(params);
        requestParams.compute("error_trace", (k, v) -> {
            if (v == null) {
                return "true";
            }
            if (v.equals("false")) {
                return null;
            }
            return v;
        });
        for (Map.Entry entry2 : requestParams.entrySet()) {
            if (!this.stash.containsStashedValue(entry2.getValue())) continue;
            entry2.setValue(this.stash.getValue((String)entry2.getValue()).toString());
        }
        HashMap<String, String> requestHeaders = new HashMap<String, String>(headers);
        for (Map.Entry entry : requestHeaders.entrySet()) {
            if (!this.stash.containsStashedValue(entry.getValue())) continue;
            entry.setValue(this.stash.getValue((String)entry.getValue()).toString());
        }
        HttpEntity entity = this.createEntity(bodies, requestHeaders);
        try {
            clientYamlTestResponse = this.response = this.callApiInternal(apiName, requestParams, entity, requestHeaders, nodeSelector);
            responseBody = this.response != null ? this.response.getBody() : null;
        }
        catch (ClientYamlTestResponseException clientYamlTestResponseException) {
            try {
                this.response = clientYamlTestResponseException.getRestTestResponse();
                throw clientYamlTestResponseException;
            }
            catch (Throwable throwable) {
                Object responseBody2 = this.response != null ? this.response.getBody() : null;
                this.stash.stashValue("body", responseBody2);
                if (!requestHeaders.isEmpty()) {
                    this.stash.stashValue("request_headers", requestHeaders);
                }
                throw throwable;
            }
        }
        this.stash.stashValue("body", responseBody);
        if (!requestHeaders.isEmpty()) {
            this.stash.stashValue("request_headers", requestHeaders);
        }
        return clientYamlTestResponse;
    }

    private HttpEntity createEntity(List<Map<String, Object>> bodies, Map<String, String> headers) throws IOException {
        if (bodies.isEmpty()) {
            return null;
        }
        if (bodies.size() == 1) {
            XContentType xContentType = this.getContentType(headers, XContentType.values());
            BytesRef bytesRef = this.bodyAsBytesRef(bodies.get(0), xContentType);
            return new ByteArrayEntity(bytesRef.bytes, bytesRef.offset, bytesRef.length, ContentType.create((String)xContentType.mediaTypeWithoutParameters(), (Charset)StandardCharsets.UTF_8));
        }
        XContentType xContentType = this.getContentType(headers, STREAMING_CONTENT_TYPES);
        ArrayList<BytesRef> bytesRefList = new ArrayList<BytesRef>(bodies.size());
        int totalBytesLength = 0;
        for (Map<String, Object> body : bodies) {
            BytesRef bytesRef = this.bodyAsBytesRef(body, xContentType);
            bytesRefList.add(bytesRef);
            totalBytesLength += bytesRef.length - bytesRef.offset + 1;
        }
        byte[] bytes = new byte[totalBytesLength];
        int position = 0;
        for (BytesRef bytesRef : bytesRefList) {
            for (int i = bytesRef.offset; i < bytesRef.length; ++i) {
                bytes[position++] = bytesRef.bytes[i];
            }
            bytes[position++] = xContentType.xContent().bulkSeparator();
        }
        return new ByteArrayEntity(bytes, ContentType.create((String)xContentType.mediaTypeWithoutParameters(), (Charset)StandardCharsets.UTF_8));
    }

    private XContentType getContentType(Map<String, String> headers, XContentType[] supportedContentTypes) {
        XContentType xContentType = null;
        String contentType = headers.get("Content-Type");
        if (contentType != null) {
            xContentType = XContentType.fromMediaType((String)contentType);
        }
        if (xContentType != null) {
            return xContentType;
        }
        if (this.randomizeContentType) {
            return (XContentType)RandomizedTest.randomFrom((Object[])supportedContentTypes);
        }
        return XContentType.JSON;
    }

    private BytesRef bodyAsBytesRef(Map<String, Object> bodyAsMap, XContentType xContentType) throws IOException {
        Map finalBodyAsMap = this.stash.replaceStashedValues(bodyAsMap);
        try (XContentBuilder builder = XContentFactory.contentBuilder((XContentType)xContentType);){
            BytesRef bytesRef = BytesReference.bytes((XContentBuilder)builder.map(finalBodyAsMap)).toBytesRef();
            return bytesRef;
        }
    }

    ClientYamlTestResponse callApiInternal(String apiName, Map<String, String> params, HttpEntity entity, Map<String, String> headers, NodeSelector nodeSelector) throws IOException {
        return this.clientYamlTestClient(apiName).callApi(apiName, params, entity, headers, nodeSelector, this.pathPredicate);
    }

    protected ClientYamlTestClient clientYamlTestClient(String apiName) {
        return this.clientYamlTestClient;
    }

    public Object response(String path) throws IOException {
        return this.response.evaluate(path, this.stash);
    }

    public void clear() {
        logger.debug("resetting client, response and stash");
        this.response = null;
        this.stash.clear();
    }

    public Stash stash() {
        return this.stash;
    }

    public Set<String> nodesVersions() {
        return this.nodesVersions;
    }

    public String os() {
        return this.osSet.iterator().next();
    }

    public ClientYamlTestCandidate getClientYamlTestCandidate() {
        return this.clientYamlTestCandidate;
    }

    public boolean clusterHasFeature(String featureId, boolean any) {
        return this.testFeatureService.clusterHasFeature(featureId, any);
    }

    public Optional<Boolean> clusterHasCapabilities(String method, String path, String parametersString, String capabilitiesString, boolean any) {
        Map params = Maps.newMapWithExpectedSize((int)6);
        params.put("method", method);
        params.put("path", path);
        if (Strings.hasLength((String)parametersString)) {
            params.put("parameters", parametersString);
        }
        if (Strings.hasLength((String)capabilitiesString)) {
            params.put("capabilities", capabilitiesString);
        }
        params.put("error_trace", "false");
        params.put("local_only", "true");
        List nodes = this.clientYamlTestClient.getRestClient(NodeSelector.ANY).getNodes();
        for (Node n : nodes) {
            Optional<Boolean> nodeResult = this.checkCapability(new SpecificNodeSelector(n), params);
            if (nodeResult.isEmpty()) {
                return Optional.empty();
            }
            if (any != nodeResult.get()) continue;
            return nodeResult;
        }
        return Optional.of(!any);
    }

    private Optional<Boolean> checkCapability(NodeSelector nodeSelector, Map<String, String> params) {
        try {
            ClientYamlTestResponse resp = this.callApi("capabilities", params, Collections.emptyList(), Collections.emptyMap(), nodeSelector);
            assert (resp.getStatusCode() == 200) : "Unknown response code " + resp.getStatusCode();
            return Optional.ofNullable((Boolean)resp.evaluate("supported"));
        }
        catch (ClientYamlTestResponseException responseException) {
            if (responseException.getRestTestResponse().getStatusCode() / 100 == 4) {
                return Optional.empty();
            }
            throw new UncheckedIOException(responseException);
        }
        catch (IOException ioException) {
            throw new UncheckedIOException(ioException);
        }
    }

    private record SpecificNodeSelector(Node node) implements NodeSelector
    {
        public void select(Iterable<Node> nodes) {
            Iterator<Node> it = nodes.iterator();
            while (it.hasNext()) {
                if (it.next().getBoundHosts().contains(this.node.getHost())) continue;
                it.remove();
            }
        }
    }
}

