/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.transform;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.gradle.api.Action;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;

public abstract class FilteringJarTransform
implements TransformAction<Parameters> {
    public static final String FILTERED_JAR_TYPE = "filtered-jar";

    @InputArtifact
    public abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(TransformOutputs outputs) {
        File original = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        File transformed = outputs.file((Object)original.getName());
        List<PathMatcher> excludes = this.createMatchers(((Parameters)this.getParameters()).getExcludes());
        try (ZipFile input = new ZipFile(original);
             ZipOutputStream output = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(transformed)));){
            Enumeration<? extends ZipEntry> entries = input.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!excludes.stream().noneMatch(e -> e.matches(Path.of(entry.getName(), new String[0])))) continue;
                output.putNextEntry(entry);
                input.getInputStream(entry).transferTo(output);
                output.closeEntry();
            }
            output.flush();
            output.finish();
        }
        catch (IOException e2) {
            throw new UncheckedIOException("Failed to patch archive", e2);
        }
    }

    private List<PathMatcher> createMatchers(List<String> patterns) {
        return patterns.stream().map(p -> FileSystems.getDefault().getPathMatcher("glob:" + p)).toList();
    }

    public static void registerTransform(DependencyHandler dependencyHandler, Action<Parameters> config) {
        dependencyHandler.registerTransform(FilteringJarTransform.class, spec -> {
            spec.getFrom().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar");
            spec.getTo().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)FILTERED_JAR_TYPE);
            config.execute((Object)((Parameters)spec.getParameters()));
        });
    }

    public static abstract class Parameters
    implements TransformParameters,
    Serializable {
        private List<String> excludes = new ArrayList<String>();

        @Input
        public List<String> getExcludes() {
            return this.excludes;
        }

        public void exclude(String exclude) {
            this.excludes.add(exclude);
        }
    }
}

