/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

public enum Architecture {
    X64("x86_64", "linux/amd64", "amd64", "x64"),
    AARCH64("aarch64", "linux/arm64", "arm64", "aarch64");

    public final String classifier;
    public final String dockerPlatform;
    public final String dockerClassifier;
    public final String javaClassifier;

    private Architecture(String classifier, String dockerPlatform, String dockerClassifier, String javaClassifier) {
        this.classifier = classifier;
        this.dockerPlatform = dockerPlatform;
        this.dockerClassifier = dockerClassifier;
        this.javaClassifier = javaClassifier;
    }

    public static Architecture current() {
        String architecture;
        return switch (architecture = System.getProperty("os.arch", "")) {
            case "amd64", "x86_64" -> X64;
            case "aarch64" -> AARCH64;
            default -> throw new IllegalArgumentException("can not determine architecture from [" + architecture + "]");
        };
    }
}

