/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rank.feature;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchShardTask;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.AbstractTransportRequest;

public class RankFeatureShardRequest
extends AbstractTransportRequest
implements IndicesRequest {
    private final OriginalIndices originalIndices;
    private final ShardSearchRequest shardSearchRequest;
    private final ShardSearchContextId contextId;
    private final int[] docIds;

    public RankFeatureShardRequest(OriginalIndices originalIndices, ShardSearchContextId contextId, ShardSearchRequest shardSearchRequest, List<Integer> docIds) {
        this.originalIndices = originalIndices;
        this.shardSearchRequest = shardSearchRequest;
        this.docIds = docIds.stream().flatMapToInt(IntStream::of).toArray();
        this.contextId = contextId;
    }

    public RankFeatureShardRequest(StreamInput in) throws IOException {
        super(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
        this.shardSearchRequest = in.readOptionalWriteable(ShardSearchRequest::new);
        this.docIds = in.readIntArray();
        this.contextId = in.readOptionalWriteable(ShardSearchContextId::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        out.writeOptionalWriteable(this.shardSearchRequest);
        out.writeIntArray(this.docIds);
        out.writeOptionalWriteable(this.contextId);
    }

    @Override
    public String[] indices() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indicesOptions();
    }

    public ShardSearchRequest getShardSearchRequest() {
        return this.shardSearchRequest;
    }

    public int[] getDocIds() {
        return this.docIds;
    }

    public ShardSearchContextId contextId() {
        return this.contextId;
    }

    @Override
    public SearchShardTask createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchShardTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }
}

