/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.env.Environment;
import org.elasticsearch.grok.MatcherWatchdog;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.Scheduler;

public interface Processor {
    default public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        if (!this.isAsync()) {
            handler.accept(null, new UnsupportedOperationException("asynchronous execute method should not be executed for sync processors"));
        }
        handler.accept(ingestDocument, null);
    }

    default public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        if (this.isAsync()) {
            throw new UnsupportedOperationException("synchronous execute method should not be executed for async processors");
        }
        return ingestDocument;
    }

    public String getType();

    public String getTag();

    public String getDescription();

    default public boolean isAsync() {
        return false;
    }

    default public void extraValidation() throws Exception {
    }

    public static class Parameters {
        public final Environment env;
        public final ScriptService scriptService;
        public final AnalysisRegistry analysisRegistry;
        public final ThreadContext threadContext;
        public final LongSupplier relativeTimeSupplier;
        public final IngestService ingestService;
        public final Consumer<Runnable> genericExecutor;
        public final BiFunction<Long, Runnable, Scheduler.ScheduledCancellable> scheduler;
        public final Client client;
        public final MatcherWatchdog matcherWatchdog;

        public Parameters(Environment env, ScriptService scriptService, AnalysisRegistry analysisRegistry, ThreadContext threadContext, LongSupplier relativeTimeSupplier, BiFunction<Long, Runnable, Scheduler.ScheduledCancellable> scheduler, IngestService ingestService, Client client, Consumer<Runnable> genericExecutor, MatcherWatchdog matcherWatchdog) {
            this.env = env;
            this.scriptService = scriptService;
            this.threadContext = threadContext;
            this.analysisRegistry = analysisRegistry;
            this.relativeTimeSupplier = relativeTimeSupplier;
            this.scheduler = scheduler;
            this.ingestService = ingestService;
            this.client = client;
            this.genericExecutor = genericExecutor;
            this.matcherWatchdog = matcherWatchdog;
        }
    }

    public static interface Factory {
        public Processor create(Map<String, Factory> var1, String var2, String var3, Map<String, Object> var4, ProjectId var5) throws Exception;
    }
}

