/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.search.ESToParentBlockJoinQuery;

public final class NestedHelper {
    private NestedHelper() {
    }

    public static boolean mightMatchNestedDocs(Query query, SearchExecutionContext searchExecutionContext) {
        if (query instanceof ConstantScoreQuery) {
            return NestedHelper.mightMatchNestedDocs(((ConstantScoreQuery)query).getQuery(), searchExecutionContext);
        }
        if (query instanceof BoostQuery) {
            return NestedHelper.mightMatchNestedDocs(((BoostQuery)query).getQuery(), searchExecutionContext);
        }
        if (query instanceof MatchAllDocsQuery) {
            return true;
        }
        if (query instanceof MatchNoDocsQuery) {
            return false;
        }
        if (query instanceof TermQuery) {
            return NestedHelper.mightMatchNestedDocs(((TermQuery)query).getTerm().field(), searchExecutionContext);
        }
        if (query instanceof TermInSetQuery) {
            TermInSetQuery tis = (TermInSetQuery)query;
            if (tis.getTermsCount() > 0L) {
                return NestedHelper.mightMatchNestedDocs(tis.getField(), searchExecutionContext);
            }
            return false;
        }
        if (query instanceof PointRangeQuery) {
            return NestedHelper.mightMatchNestedDocs(((PointRangeQuery)query).getField(), searchExecutionContext);
        }
        if (query instanceof IndexOrDocValuesQuery) {
            return NestedHelper.mightMatchNestedDocs(((IndexOrDocValuesQuery)query).getIndexQuery(), searchExecutionContext);
        }
        if (query instanceof BooleanQuery) {
            BooleanQuery bq = (BooleanQuery)query;
            boolean hasRequiredClauses = bq.clauses().stream().anyMatch(BooleanClause::isRequired);
            if (hasRequiredClauses) {
                return bq.clauses().stream().filter(BooleanClause::isRequired).map(BooleanClause::query).allMatch(f -> NestedHelper.mightMatchNestedDocs(f, searchExecutionContext));
            }
            return bq.clauses().stream().filter(c -> c.occur() == BooleanClause.Occur.SHOULD).map(BooleanClause::query).anyMatch(f -> NestedHelper.mightMatchNestedDocs(f, searchExecutionContext));
        }
        if (query instanceof ESToParentBlockJoinQuery) {
            return ((ESToParentBlockJoinQuery)query).getPath() != null;
        }
        return true;
    }

    private static boolean mightMatchNestedDocs(String field, SearchExecutionContext searchExecutionContext) {
        if (field.startsWith("_")) {
            return true;
        }
        if (!searchExecutionContext.isFieldMapped(field)) {
            return false;
        }
        return searchExecutionContext.nestedLookup().getNestedParent(field) != null;
    }

    public static boolean mightMatchNonNestedDocs(Query query, String nestedPath, SearchExecutionContext searchExecutionContext) {
        if (query instanceof ConstantScoreQuery) {
            return NestedHelper.mightMatchNonNestedDocs(((ConstantScoreQuery)query).getQuery(), nestedPath, searchExecutionContext);
        }
        if (query instanceof BoostQuery) {
            return NestedHelper.mightMatchNonNestedDocs(((BoostQuery)query).getQuery(), nestedPath, searchExecutionContext);
        }
        if (query instanceof MatchAllDocsQuery) {
            return true;
        }
        if (query instanceof MatchNoDocsQuery) {
            return false;
        }
        if (query instanceof TermQuery) {
            return NestedHelper.mightMatchNonNestedDocs(searchExecutionContext, ((TermQuery)query).getTerm().field(), nestedPath);
        }
        if (query instanceof TermInSetQuery) {
            TermInSetQuery tis = (TermInSetQuery)query;
            if (tis.getTermsCount() > 0L) {
                return NestedHelper.mightMatchNonNestedDocs(searchExecutionContext, tis.getField(), nestedPath);
            }
            return false;
        }
        if (query instanceof PointRangeQuery) {
            return NestedHelper.mightMatchNonNestedDocs(searchExecutionContext, ((PointRangeQuery)query).getField(), nestedPath);
        }
        if (query instanceof IndexOrDocValuesQuery) {
            return NestedHelper.mightMatchNonNestedDocs(((IndexOrDocValuesQuery)query).getIndexQuery(), nestedPath, searchExecutionContext);
        }
        if (query instanceof BooleanQuery) {
            BooleanQuery bq = (BooleanQuery)query;
            boolean hasRequiredClauses = bq.clauses().stream().anyMatch(BooleanClause::isRequired);
            if (hasRequiredClauses) {
                return bq.clauses().stream().filter(BooleanClause::isRequired).map(BooleanClause::query).allMatch(q -> NestedHelper.mightMatchNonNestedDocs(q, nestedPath, searchExecutionContext));
            }
            return bq.clauses().stream().filter(c -> c.occur() == BooleanClause.Occur.SHOULD).map(BooleanClause::query).anyMatch(q -> NestedHelper.mightMatchNonNestedDocs(q, nestedPath, searchExecutionContext));
        }
        return true;
    }

    private static boolean mightMatchNonNestedDocs(SearchExecutionContext searchExecutionContext, String field, String nestedPath) {
        if (field.startsWith("_")) {
            return true;
        }
        if (!searchExecutionContext.isFieldMapped(field)) {
            return false;
        }
        NestedLookup nestedLookup = searchExecutionContext.nestedLookup();
        String nestedParent = nestedLookup.getNestedParent(field);
        if (nestedParent == null || !nestedParent.startsWith(nestedPath)) {
            return true;
        }
        NestedObjectMapper nestedMapper = nestedLookup.getNestedMappers().get(nestedParent);
        if (nestedParent.equals(nestedPath)) {
            return nestedMapper.isIncludeInParent() || nestedMapper.isIncludeInRoot();
        }
        return true;
    }
}

