/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.uid;

import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.common.lucene.uid.PerThreadIDVersionAndSeqNoLookup;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.Assertions;

public final class VersionsAndSeqNoResolver {
    static final ConcurrentMap<IndexReader.CacheKey, CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]>> lookupStates = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private static final IndexReader.ClosedListener removeLookupState = key -> {
        CloseableThreadLocal ctl = (CloseableThreadLocal)lookupStates.remove(key);
        if (ctl != null) {
            ctl.close();
        }
    };

    private static PerThreadIDVersionAndSeqNoLookup[] getLookupState(IndexReader reader, boolean loadTimestampRange) throws IOException {
        PerThreadIDVersionAndSeqNoLookup[] lookupState;
        IndexReader.CacheHelper cacheHelper = reader.getReaderCacheHelper();
        CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]> ctl = (CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]>)lookupStates.get(cacheHelper.getKey());
        if (ctl == null) {
            ctl = new CloseableThreadLocal();
            CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]> other = lookupStates.putIfAbsent(cacheHelper.getKey(), ctl);
            if (other == null) {
                cacheHelper.addClosedListener(removeLookupState);
            } else {
                ctl = other;
            }
        }
        if ((lookupState = (PerThreadIDVersionAndSeqNoLookup[])ctl.get()) == null) {
            lookupState = new PerThreadIDVersionAndSeqNoLookup[reader.leaves().size()];
            for (LeafReaderContext leaf : reader.leaves()) {
                lookupState[leaf.ord] = new PerThreadIDVersionAndSeqNoLookup(leaf.reader(), loadTimestampRange);
            }
            ctl.set((Object)lookupState);
        } else if (Assertions.ENABLED) {
            for (PerThreadIDVersionAndSeqNoLookup lookup : lookupState) {
                if (lookup.loadedTimestampRange != loadTimestampRange) {
                    throw new AssertionError((Object)("Mismatch between lookup.loadedTimestampRange [" + lookup.loadedTimestampRange + "] and loadTimestampRange [" + loadTimestampRange + "]"));
                }
            }
        }
        if (lookupState.length != reader.leaves().size()) {
            throw new AssertionError((Object)("Mismatched numbers of leaves: " + lookupState.length + " != " + reader.leaves().size()));
        }
        return lookupState;
    }

    private VersionsAndSeqNoResolver() {
    }

    public static DocIdAndVersion timeSeriesLoadDocIdAndVersion(IndexReader reader, BytesRef term, boolean loadSeqNo) throws IOException {
        PerThreadIDVersionAndSeqNoLookup[] lookups = VersionsAndSeqNoResolver.getLookupState(reader, false);
        List leaves = reader.leaves();
        for (int i = leaves.size() - 1; i >= 0; --i) {
            LeafReaderContext leaf;
            PerThreadIDVersionAndSeqNoLookup lookup = lookups[leaf.ord];
            leaf = (LeafReaderContext)leaves.get(i);
            DocIdAndVersion result = lookup.lookupVersion(term, loadSeqNo, leaf);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static DocIdAndVersion timeSeriesLoadDocIdAndVersion(IndexReader reader, BytesRef uid, String id, boolean loadSeqNo) throws IOException {
        byte[] idAsBytes = Base64.getUrlDecoder().decode(id);
        assert (idAsBytes.length == 20);
        long timestamp = ByteUtils.readLongBE(idAsBytes, 12);
        PerThreadIDVersionAndSeqNoLookup[] lookups = VersionsAndSeqNoResolver.getLookupState(reader, true);
        List leaves = reader.leaves();
        long prevMaxTimestamp = Long.MAX_VALUE;
        for (LeafReaderContext leaf : leaves) {
            PerThreadIDVersionAndSeqNoLookup lookup = lookups[leaf.ord];
            assert (lookup.loadedTimestampRange);
            assert (prevMaxTimestamp >= lookup.maxTimestamp);
            if (timestamp < lookup.minTimestamp) continue;
            if (timestamp > lookup.maxTimestamp) {
                return null;
            }
            DocIdAndVersion result = lookup.lookupVersion(uid, loadSeqNo, leaf);
            if (result != null) {
                return result;
            }
            prevMaxTimestamp = lookup.maxTimestamp;
        }
        return null;
    }

    public static DocIdAndVersion loadDocIdAndVersionUncached(IndexReader reader, BytesRef term, boolean loadSeqNo) throws IOException {
        List leaves = reader.leaves();
        for (int i = leaves.size() - 1; i >= 0; --i) {
            LeafReaderContext leaf = (LeafReaderContext)leaves.get(i);
            PerThreadIDVersionAndSeqNoLookup lookup = new PerThreadIDVersionAndSeqNoLookup(leaf.reader(), false, false);
            DocIdAndVersion result = lookup.lookupVersion(term, loadSeqNo, leaf);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static DocIdAndSeqNo loadDocIdAndSeqNo(IndexReader reader, BytesRef term) throws IOException {
        PerThreadIDVersionAndSeqNoLookup[] lookups = VersionsAndSeqNoResolver.getLookupState(reader, false);
        List leaves = reader.leaves();
        for (int i = leaves.size() - 1; i >= 0; --i) {
            LeafReaderContext leaf;
            PerThreadIDVersionAndSeqNoLookup lookup = lookups[leaf.ord];
            leaf = (LeafReaderContext)leaves.get(i);
            DocIdAndSeqNo result = lookup.lookupSeqNo(term, leaf);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static class DocIdAndVersion {
        public final int docId;
        public final long version;
        public final long seqNo;
        public final long primaryTerm;
        public final LeafReader reader;
        public final int docBase;

        public DocIdAndVersion(int docId, long version, long seqNo, long primaryTerm, LeafReader reader, int docBase) {
            this.docId = docId;
            this.version = version;
            this.seqNo = seqNo;
            this.primaryTerm = primaryTerm;
            this.reader = reader;
            this.docBase = docBase;
        }
    }

    public static class DocIdAndSeqNo {
        public final int docId;
        public final long seqNo;
        public final LeafReaderContext context;

        DocIdAndSeqNo(int docId, long seqNo, LeafReaderContext context) {
            this.docId = docId;
            this.seqNo = seqNo;
            this.context = context;
        }
    }
}

