/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamOutput;

public class CountingStreamOutput
extends StreamOutput {
    private long size;

    public void reset() {
        this.size = 0L;
    }

    public long size() {
        return this.size;
    }

    @Override
    public void writeByte(byte b) {
        ++this.size;
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) {
        this.size += (long)length;
    }

    @Override
    public void writeInt(int i) {
        this.size += 4L;
    }

    @Override
    public void writeIntArray(int[] values) throws IOException {
        this.writeVInt(values.length);
        this.size += (long)values.length * 4L;
    }

    @Override
    public void writeLong(long i) {
        this.size += 8L;
    }

    @Override
    public void writeLongArray(long[] values) throws IOException {
        this.writeVInt(values.length);
        this.size += (long)values.length * 8L;
    }

    @Override
    public void writeFloat(float v) {
        this.size += 4L;
    }

    @Override
    public void writeFloatArray(float[] values) throws IOException {
        this.writeVInt(values.length);
        this.size += (long)values.length * 4L;
    }

    @Override
    public void writeDouble(double v) {
        this.size += 8L;
    }

    @Override
    public void writeDoubleArray(double[] values) throws IOException {
        this.writeVInt(values.length);
        this.size += (long)values.length * 8L;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

