/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;

public class RebalanceOnlyWhenActiveAllocationDecider
extends AllocationDecider {
    public static final String NAME = "rebalance_only_when_active";
    static final Decision YES_ALL_REPLICAS_ACTIVE = Decision.single(Decision.Type.YES, "rebalance_only_when_active", "rebalancing is allowed as all copies of this shard are active", new Object[0]);
    static final Decision NO_SOME_REPLICAS_INACTIVE = Decision.single(Decision.Type.NO, "rebalance_only_when_active", "rebalancing is not allowed until all copies of this shard are active", new Object[0]);

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        return allocation.routingNodes().allShardsActive(shardRouting.shardId(), allocation.metadata().projectFor(shardRouting.index())) ? YES_ALL_REPLICAS_ACTIVE : NO_SOME_REPLICAS_INACTIVE;
    }
}

