/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.function.LongConsumer;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.ElectionStrategy;
import org.elasticsearch.cluster.coordination.LeaderHeartbeatService;
import org.elasticsearch.cluster.coordination.PreVoteResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.monitor.NodeHealthService;
import org.elasticsearch.transport.TransportService;

public abstract class PreVoteCollector {
    private static final Logger logger = LogManager.getLogger(PreVoteCollector.class);
    protected volatile Tuple<DiscoveryNode, PreVoteResponse> state;

    PreVoteResponse getPreVoteResponse() {
        return (PreVoteResponse)this.state.v2();
    }

    @Nullable
    DiscoveryNode getLeader() {
        return (DiscoveryNode)this.state.v1();
    }

    public void update(PreVoteResponse preVoteResponse, @Nullable DiscoveryNode leader) {
        logger.trace("updating with preVoteResponse={}, leader={}", new Object[]{preVoteResponse, leader});
        this.state = new Tuple((Object)leader, (Object)preVoteResponse);
    }

    public abstract Releasable start(ClusterState var1, Iterable<DiscoveryNode> var2);

    public static interface Factory {
        public PreVoteCollector create(TransportService var1, Runnable var2, LongConsumer var3, ElectionStrategy var4, NodeHealthService var5, LeaderHeartbeatService var6);
    }
}

