/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.CleanableResponseHandler;
import org.elasticsearch.cluster.coordination.CoordinationStateRejectedException;
import org.elasticsearch.cluster.coordination.JoinHelper;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.transport.BytesTransportRequest;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class JoinValidationService {
    private static final Logger logger = LogManager.getLogger(JoinValidationService.class);
    public static final String JOIN_VALIDATE_ACTION_NAME = "internal:cluster/coordination/join/validate";
    public static final Setting<TimeValue> JOIN_VALIDATION_CACHE_TIMEOUT_SETTING = Setting.timeSetting("cluster.join_validation.cache_timeout", TimeValue.timeValueSeconds((long)60L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    private static final TransportRequestOptions REQUEST_OPTIONS = TransportRequestOptions.of(null, TransportRequestOptions.Type.STATE);
    private final TimeValue cacheTimeout;
    private final TransportService transportService;
    private final Supplier<ClusterState> clusterStateSupplier;
    private final AtomicInteger queueSize = new AtomicInteger();
    private final Queue<AbstractRunnable> queue = new ConcurrentLinkedQueue<AbstractRunnable>();
    private final Map<TransportVersion, ReleasableBytesReference> statesByVersion = new HashMap<TransportVersion, ReleasableBytesReference>();
    private final RefCounted executeRefs;
    private final Executor responseExecutor;
    private final AbstractRunnable processor = new AbstractRunnable(){

        @Override
        protected void doRun() {
            JoinValidationService.this.processNextItem();
        }

        @Override
        public void onRejection(Exception e) {
            EsRejectedExecutionException esre;
            assert (e instanceof EsRejectedExecutionException && (esre = (EsRejectedExecutionException)e).isExecutorShutdown());
            JoinValidationService.this.onShutdown();
        }

        @Override
        public void onFailure(Exception e) {
            logger.error("unexpectedly failed to process queue item", (Throwable)e);
            assert (false) : e;
        }

        public String toString() {
            return "process next task of join validation service";
        }
    };
    private final AbstractRunnable cacheClearer = new AbstractRunnable(){

        @Override
        public void onFailure(Exception e) {
            logger.error("unexpectedly failed to clear cache", (Throwable)e);
            assert (false) : e;
        }

        @Override
        protected void doRun() {
            for (ReleasableBytesReference bytes : JoinValidationService.this.statesByVersion.values()) {
                bytes.decRef();
            }
            JoinValidationService.this.statesByVersion.clear();
            logger.trace("join validation cache cleared");
        }

        public String toString() {
            return "clear join validation cache";
        }
    };

    public JoinValidationService(Settings settings, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, Supplier<ClusterState> clusterStateSupplier, Supplier<Metadata> metadataSupplier, Collection<BiConsumer<DiscoveryNode, ClusterState>> joinValidators) {
        this.cacheTimeout = JOIN_VALIDATION_CACHE_TIMEOUT_SETTING.get(settings);
        this.transportService = transportService;
        this.clusterStateSupplier = clusterStateSupplier;
        this.executeRefs = AbstractRefCounted.of(() -> this.execute(this.cacheClearer));
        this.responseExecutor = transportService.getThreadPool().executor("cluster_coordination");
        List<String> dataPaths = Environment.PATH_DATA_SETTING.get(settings);
        transportService.registerRequestHandler(JOIN_VALIDATE_ACTION_NAME, this.responseExecutor, BytesTransportRequest::new, (request, channel, task) -> {
            ClusterState remoteState = JoinValidationService.readClusterState(namedWriteableRegistry, request);
            Metadata remoteMetadata = remoteState.metadata();
            Metadata localMetadata = (Metadata)metadataSupplier.get();
            if (localMetadata.clusterUUIDCommitted() && !localMetadata.clusterUUID().equals(remoteMetadata.clusterUUID())) {
                throw new CoordinationStateRejectedException("This node previously joined a cluster with UUID [" + localMetadata.clusterUUID() + "] and is now trying to join a different cluster with UUID [" + remoteMetadata.clusterUUID() + "]. This is forbidden and usually indicates an incorrect discovery or cluster bootstrapping configuration. Note that the cluster UUID persists across restarts and can only be changed by deleting the contents of the node's data " + (dataPaths.size() == 1 ? "path " : "paths ") + String.valueOf(dataPaths) + " which will also remove any data held by this node.", new Object[0]);
            }
            joinValidators.forEach(joinValidator -> joinValidator.accept(transportService.getLocalNode(), remoteState));
            channel.sendResponse(ActionResponse.Empty.INSTANCE);
        });
    }

    private static ClusterState readClusterState(NamedWriteableRegistry namedWriteableRegistry, BytesTransportRequest request) throws IOException {
        try (StreamInput bytesStreamInput = request.bytes().streamInput();){
            ClusterState clusterState;
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(CompressorFactory.COMPRESSOR.threadLocalStreamInput(bytesStreamInput), namedWriteableRegistry);){
                in.setTransportVersion(request.version());
                clusterState = ClusterState.readFrom(in, null);
            }
            return clusterState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateJoin(DiscoveryNode discoveryNode, ActionListener<Void> listener) {
        Transport.Connection connection;
        try {
            connection = this.transportService.getConnection(discoveryNode);
            assert (connection != null);
        }
        catch (Exception e) {
            assert (e instanceof NodeNotConnectedException) : e;
            listener.onFailure(e);
            return;
        }
        if (this.executeRefs.tryIncRef()) {
            try {
                this.execute(new JoinValidation(discoveryNode, connection, listener));
            }
            finally {
                this.executeRefs.decRef();
            }
        } else {
            listener.onFailure(new NodeClosedException(this.transportService.getLocalNode()));
        }
    }

    public void stop() {
        this.executeRefs.decRef();
    }

    boolean isIdle() {
        return this.queue.isEmpty() && this.queueSize.get() == 0 && this.statesByVersion.isEmpty();
    }

    private void execute(AbstractRunnable task) {
        assert (task == this.cacheClearer || this.executeRefs.hasReferences());
        this.queue.add(task);
        if (this.queueSize.getAndIncrement() == 0) {
            this.runProcessor();
        }
    }

    private void runProcessor() {
        this.transportService.getThreadPool().executor("cluster_coordination").execute(this.processor);
    }

    private void processNextItem() {
        if (!this.executeRefs.hasReferences()) {
            this.onShutdown();
            return;
        }
        AbstractRunnable nextItem = this.queue.poll();
        assert (nextItem != null);
        try {
            nextItem.run();
        }
        finally {
            try {
                int remaining = this.queueSize.decrementAndGet();
                assert (remaining >= 0);
                if (remaining > 0) {
                    this.runProcessor();
                }
            }
            catch (Exception e) {
                assert (false) : e;
                throw e;
            }
        }
    }

    private void onShutdown() {
        try {
            this.cacheClearer.run();
            do {
                AbstractRunnable nextItem = this.queue.poll();
                assert (nextItem != null);
                if (nextItem == this.cacheClearer) continue;
                nextItem.onFailure(new NodeClosedException(this.transportService.getLocalNode()));
            } while (this.queueSize.decrementAndGet() > 0);
        }
        catch (Exception e) {
            assert (false) : e;
            throw e;
        }
    }

    @Nullable
    private ReleasableBytesReference maybeSerializeClusterState(ReleasableBytesReference cachedBytes, DiscoveryNode discoveryNode, TransportVersion version) {
        if (cachedBytes != null) {
            return cachedBytes;
        }
        ClusterState clusterState = this.clusterStateSupplier.get();
        if (clusterState == null) {
            return null;
        }
        assert (clusterState.nodes().isLocalNodeElectedMaster());
        try (RecyclerBytesStreamOutput bytesStream = this.transportService.newNetworkBytesStream();){
            try (OutputStreamStreamOutput stream = new OutputStreamStreamOutput(CompressorFactory.COMPRESSOR.threadLocalOutputStream(Streams.flushOnCloseStream(bytesStream)));){
                stream.setTransportVersion(version);
                clusterState.writeTo(stream);
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to serialize cluster state for publishing to node {}", (Throwable)e, discoveryNode);
            }
            logger.trace("serialized join validation cluster state version [{}] for transport version [{}] with size [{}]", (Object)clusterState.version(), (Object)version, (Object)bytesStream.position());
            ReleasableBytesReference newBytes = bytesStream.moveToBytesReference();
            ReleasableBytesReference previousBytes = this.statesByVersion.put(version, newBytes);
            assert (previousBytes == null);
            ReleasableBytesReference releasableBytesReference = newBytes;
            return releasableBytesReference;
        }
    }

    private class JoinValidation
    extends ActionRunnable<Void> {
        private final DiscoveryNode discoveryNode;
        private final Transport.Connection connection;

        JoinValidation(DiscoveryNode discoveryNode, Transport.Connection connection, ActionListener<Void> listener) {
            super(listener);
            this.discoveryNode = discoveryNode;
            this.connection = connection;
        }

        @Override
        protected void doRun() {
            TransportVersion transportVersion = this.connection.getTransportVersion();
            ReleasableBytesReference cachedBytes = JoinValidationService.this.statesByVersion.get(transportVersion);
            ReleasableBytesReference bytes = JoinValidationService.this.maybeSerializeClusterState(cachedBytes, this.discoveryNode, transportVersion);
            if (bytes == null) {
                assert (cachedBytes == null);
                JoinValidationService.this.transportService.sendRequest(this.connection, "internal:cluster/coordination/join/ping", (TransportRequest)new JoinHelper.JoinPingRequest(), REQUEST_OPTIONS, TransportResponseHandler.empty(JoinValidationService.this.responseExecutor, this.listener));
                return;
            }
            bytes.mustIncRef();
            JoinValidationService.this.transportService.sendRequest(this.connection, JoinValidationService.JOIN_VALIDATE_ACTION_NAME, (TransportRequest)new BytesTransportRequest(bytes, transportVersion), REQUEST_OPTIONS, new CleanableResponseHandler<ActionResponse.Empty>(this.listener.map(ignored -> null), in -> ActionResponse.Empty.INSTANCE, JoinValidationService.this.responseExecutor, bytes::decRef));
            try {
                if (cachedBytes == null) {
                    JoinValidationService.this.transportService.getThreadPool().schedule(new Runnable(){

                        @Override
                        public void run() {
                            JoinValidationService.this.execute(JoinValidationService.this.cacheClearer);
                        }

                        public String toString() {
                            return String.valueOf(JoinValidationService.this.cacheClearer) + " after timeout";
                        }
                    }, JoinValidationService.this.cacheTimeout, JoinValidationService.this.responseExecutor);
                }
            }
            catch (Exception e) {
                EsRejectedExecutionException esre;
                assert (e instanceof EsRejectedExecutionException && (esre = (EsRejectedExecutionException)e).isExecutorShutdown()) : e;
                JoinValidationService.this.execute(JoinValidationService.this.cacheClearer);
            }
        }

        @Override
        public String toString() {
            return "send cached join validation request to " + String.valueOf(this.discoveryNode);
        }
    }
}

