/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.Optional;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateSupplier;
import org.elasticsearch.gateway.GatewayService;

public class SafeClusterStateSupplier
implements ClusterStateSupplier,
ClusterStateListener {
    private volatile ClusterState currentClusterState;

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (this.isInitialized() || !event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            this.currentClusterState = event.state();
        }
    }

    private boolean isInitialized() {
        return this.currentClusterState != null;
    }

    @Override
    public Optional<ClusterState> get() {
        return Optional.ofNullable(this.currentClusterState);
    }
}

