/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams.lifecycle;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetDataStreamLifecycleAction {
    public static final ActionType<Response> INSTANCE = new ActionType("indices:admin/data_stream/lifecycle/get");

    private GetDataStreamLifecycleAction() {
    }

    public static class Response
    extends ActionResponse
    implements ChunkedToXContentObject {
        public static final ParseField DATA_STREAMS_FIELD = new ParseField("data_streams", new String[0]);
        private final List<DataStreamLifecycle> dataStreamLifecycles;
        @Nullable
        private final RolloverConfiguration rolloverConfiguration;
        @Nullable
        private final DataStreamGlobalRetention globalRetention;

        public Response(List<DataStreamLifecycle> dataStreamLifecycles) {
            this(dataStreamLifecycles, null, null);
        }

        public Response(List<DataStreamLifecycle> dataStreamLifecycles, @Nullable RolloverConfiguration rolloverConfiguration, @Nullable DataStreamGlobalRetention globalRetention) {
            this.dataStreamLifecycles = dataStreamLifecycles;
            this.rolloverConfiguration = rolloverConfiguration;
            this.globalRetention = globalRetention;
        }

        public List<DataStreamLifecycle> getDataStreamLifecycles() {
            return this.dataStreamLifecycles;
        }

        @Nullable
        public RolloverConfiguration getRolloverConfiguration() {
            return this.rolloverConfiguration;
        }

        public DataStreamGlobalRetention getGlobalRetention() {
            return this.globalRetention;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.dataStreamLifecycles);
            out.writeOptionalWriteable(this.rolloverConfiguration);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_14_0)) {
                out.writeOptionalWriteable(this.globalRetention);
            }
        }

        public Iterator<ToXContent> toXContentChunked(ToXContent.Params outerParams) {
            return Iterators.concat(Iterators.single((builder, params) -> {
                builder.startObject();
                builder.startObject("global_retention");
                if (this.globalRetention != null) {
                    if (this.globalRetention.maxRetention() != null) {
                        builder.field("max_retention", this.globalRetention.maxRetention().getStringRep());
                    }
                    if (this.globalRetention.defaultRetention() != null) {
                        builder.field("default_retention", this.globalRetention.defaultRetention().getStringRep());
                    }
                }
                builder.endObject();
                builder.startArray(DATA_STREAMS_FIELD.getPreferredName());
                return builder;
            }), Iterators.map(this.dataStreamLifecycles.iterator(), dataStreamLifecycle -> (builder, params) -> dataStreamLifecycle.toXContent(builder, outerParams, this.rolloverConfiguration, this.globalRetention)), Iterators.single((builder, params) -> {
                builder.endArray();
                builder.endObject();
                return builder;
            }));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.dataStreamLifecycles.equals(response.dataStreamLifecycles) && Objects.equals(this.rolloverConfiguration, response.rolloverConfiguration) && Objects.equals(this.globalRetention, response.globalRetention);
        }

        public int hashCode() {
            return Objects.hash(this.dataStreamLifecycles, this.rolloverConfiguration, this.globalRetention);
        }

        public record DataStreamLifecycle(String dataStreamName, @Nullable org.elasticsearch.cluster.metadata.DataStreamLifecycle lifecycle, boolean isInternalDataStream) implements Writeable,
        ToXContentObject
        {
            public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
            public static final ParseField LIFECYCLE_FIELD = new ParseField("lifecycle", new String[0]);

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.dataStreamName);
                out.writeOptionalWriteable(this.lifecycle);
                if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0)) {
                    out.writeBoolean(this.isInternalDataStream);
                }
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return this.toXContent(builder, params, null, null);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration, @Nullable DataStreamGlobalRetention globalRetention) throws IOException {
                builder.startObject();
                builder.field(NAME_FIELD.getPreferredName(), this.dataStreamName);
                if (this.lifecycle != null) {
                    builder.field(LIFECYCLE_FIELD.getPreferredName());
                    this.lifecycle.toXContent(builder, org.elasticsearch.cluster.metadata.DataStreamLifecycle.addEffectiveRetentionParams(params), rolloverConfiguration, globalRetention, this.isInternalDataStream);
                }
                builder.endObject();
                return builder;
            }
        }
    }

    public static class Request
    extends LocalClusterStateRequest
    implements IndicesRequest.Replaceable {
        private String[] names;
        private IndicesOptions indicesOptions = IndicesOptions.builder().concreteTargetOptions(IndicesOptions.ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(IndicesOptions.WildcardOptions.builder().matchOpen(true).matchClosed(true).includeHidden(false).resolveAliases(false).allowEmptyExpressions(true).build()).gatekeeperOptions(IndicesOptions.GatekeeperOptions.builder().allowAliasToMultipleIndices(false).allowClosedIndices(true).ignoreThrottled(false).allowSelectors(false).build()).build();
        private boolean includeDefaults = false;

        public Request(TimeValue masterNodeTimeout, String[] names) {
            super(masterNodeTimeout);
            this.names = names;
        }

        public Request(TimeValue masterNodeTimeout, String[] names, boolean includeDefaults) {
            super(masterNodeTimeout);
            this.names = names;
            this.includeDefaults = includeDefaults;
        }

        public String[] getNames() {
            return this.names;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readOptionalStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions(in);
            this.includeDefaults = in.readBoolean();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.names, request.names) && this.indicesOptions.equals(request.indicesOptions) && this.includeDefaults == request.includeDefaults;
        }

        public int hashCode() {
            int result = Objects.hash(this.indicesOptions, this.includeDefaults);
            result = 31 * result + Arrays.hashCode(this.names);
            return result;
        }

        @Override
        public String[] indices() {
            return this.names;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public boolean includeDefaults() {
            return this.includeDefaults;
        }

        public Request indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        @Override
        public IndicesRequest indices(String ... indices) {
            this.names = indices;
            return this;
        }

        public Request includeDefaults(boolean includeDefaults) {
            this.includeDefaults = includeDefaults;
            return this;
        }
    }
}

