/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoMetrics;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.node.NodeService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.transport.TransportService;

public class TransportNodesInfoAction
extends TransportNodesAction<NodesInfoRequest, NodesInfoResponse, NodeInfoRequest, NodeInfo, Void> {
    public static final ActionType<NodesInfoResponse> TYPE = new ActionType("cluster:monitor/nodes/info");
    private final NodeService nodeService;

    @Inject
    public TransportNodesInfoAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, NodeService nodeService, ActionFilters actionFilters) {
        super(TYPE.name(), clusterService, transportService, actionFilters, NodeInfoRequest::new, threadPool.executor("management"));
        this.nodeService = nodeService;
    }

    @Override
    protected NodesInfoResponse newResponse(NodesInfoRequest nodesInfoRequest, List<NodeInfo> responses, List<FailedNodeException> failures) {
        return new NodesInfoResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeInfoRequest newNodeRequest(NodesInfoRequest request) {
        return new NodeInfoRequest(request);
    }

    @Override
    protected NodeInfo newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeInfo(in);
    }

    @Override
    protected NodeInfo nodeOperation(NodeInfoRequest nodeRequest, Task task) {
        Set<String> metrics = nodeRequest.requestedMetrics();
        return this.nodeService.info(metrics.contains(NodesInfoMetrics.Metric.SETTINGS.metricName()), metrics.contains(NodesInfoMetrics.Metric.OS.metricName()), metrics.contains(NodesInfoMetrics.Metric.PROCESS.metricName()), metrics.contains(NodesInfoMetrics.Metric.JVM.metricName()), metrics.contains(NodesInfoMetrics.Metric.THREAD_POOL.metricName()), metrics.contains(NodesInfoMetrics.Metric.TRANSPORT.metricName()), metrics.contains(NodesInfoMetrics.Metric.HTTP.metricName()), metrics.contains(NodesInfoMetrics.Metric.REMOTE_CLUSTER_SERVER.metricName()), metrics.contains(NodesInfoMetrics.Metric.PLUGINS.metricName()), metrics.contains(NodesInfoMetrics.Metric.INGEST.metricName()), metrics.contains(NodesInfoMetrics.Metric.AGGREGATIONS.metricName()), metrics.contains(NodesInfoMetrics.Metric.INDICES.metricName()));
    }

    public static class NodeInfoRequest
    extends AbstractTransportRequest {
        private final NodesInfoMetrics nodesInfoMetrics;

        public NodeInfoRequest(StreamInput in) throws IOException {
            super(in);
            this.nodesInfoMetrics = new NodesInfoMetrics(in);
        }

        public NodeInfoRequest(NodesInfoRequest request) {
            this.nodesInfoMetrics = request.getNodesInfoMetrics();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.nodesInfoMetrics.writeTo(out);
        }

        public Set<String> requestedMetrics() {
            return this.nodesInfoMetrics.requestedMetrics();
        }
    }
}

