/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.querydsl.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.compute.querydsl.query.SingleValueMatchQuery;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.esql.core.tree.Location;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class SingleValueQuery
extends org.elasticsearch.xpack.esql.core.querydsl.query.Query {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(QueryBuilder.class, "esql_single_value", Builder::new);
    private final org.elasticsearch.xpack.esql.core.querydsl.query.Query next;
    private final String field;
    private final UseSyntheticSourceDelegate useSyntheticSourceDelegate;

    public SingleValueQuery(org.elasticsearch.xpack.esql.core.querydsl.query.Query next, String field, boolean useSyntheticSourceDelegate) {
        this(next, field, useSyntheticSourceDelegate ? UseSyntheticSourceDelegate.YES : UseSyntheticSourceDelegate.NO);
    }

    public SingleValueQuery(org.elasticsearch.xpack.esql.core.querydsl.query.Query next, String field, UseSyntheticSourceDelegate useSyntheticSourceDelegate) {
        super(next.source());
        this.next = next;
        this.field = field;
        this.useSyntheticSourceDelegate = useSyntheticSourceDelegate;
    }

    protected AbstractBuilder asBuilder() {
        return switch (this.useSyntheticSourceDelegate.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new Builder(this.next.toQueryBuilder(), this.field, this.next.source());
            case 1 -> new SyntheticSourceDelegateBuilder(this.next.toQueryBuilder(), this.field, this.next.source());
            case 2 -> new NegatedSyntheticSourceDelegateBuilder(this.next.toQueryBuilder(), this.field, this.next.source());
        };
    }

    protected String innerToString() {
        return this.next.toString();
    }

    public SingleValueQuery negate(Source source) {
        org.elasticsearch.xpack.esql.core.querydsl.query.Query query = this.next.negate(source);
        return new SingleValueQuery(query, this.field, switch (this.useSyntheticSourceDelegate.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> UseSyntheticSourceDelegate.NO;
            case 1 -> UseSyntheticSourceDelegate.YES_NEGATED;
            case 2 -> UseSyntheticSourceDelegate.YES;
        });
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        SingleValueQuery other = (SingleValueQuery)((Object)o);
        return Objects.equals(this.next, other.next) && Objects.equals(this.field, other.field) && this.useSyntheticSourceDelegate == other.useSyntheticSourceDelegate;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.next, this.field, this.useSyntheticSourceDelegate});
    }

    public boolean containsPlan() {
        return this.next.containsPlan();
    }

    static void writeOldSource(StreamOutput out, Source source) throws IOException {
        out.writeInt(source.source().getLineNumber());
        out.writeInt(source.source().getColumnNumber());
        out.writeString(source.text());
    }

    static Source readOldSource(StreamInput in) throws IOException {
        int line = in.readInt();
        int column = in.readInt();
        int charPositionInLine = column - 1;
        String text = in.readString();
        return new Source(new Location(line, charPositionInLine), text);
    }

    public static enum UseSyntheticSourceDelegate {
        NO,
        YES,
        YES_NEGATED;

    }

    public static class Builder
    extends AbstractBuilder {
        Builder(QueryBuilder next, String field, Source source) {
            super(next, field, source);
        }

        Builder(StreamInput in) throws IOException {
            super(in);
        }

        public String getWriteableName() {
            return SingleValueQuery.ENTRY.name;
        }

        protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(SingleValueQuery.ENTRY.name);
            builder.field("field", this.field());
            builder.field("next", (ToXContent)this.next(), params);
            builder.field("source", this.source().toString());
            builder.endObject();
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_8_11_X;
        }

        protected final Query doToQuery(SearchExecutionContext context) throws IOException {
            MappedFieldType ft = context.getFieldType(this.field());
            if (ft == null) {
                return new MatchNoDocsQuery("missing field [" + this.field() + "]");
            }
            return this.simple(ft, context);
        }

        @Override
        protected AbstractBuilder rewrite(QueryBuilder next) {
            return new Builder(next, this.field(), this.source());
        }
    }

    public static class SyntheticSourceDelegateBuilder
    extends AbstractBuilder {
        SyntheticSourceDelegateBuilder(QueryBuilder next, String field, Source source) {
            super(next, field, source);
        }

        public String getWriteableName() {
            throw new UnsupportedOperationException("Not serialized");
        }

        protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(SingleValueQuery.ENTRY.name);
            builder.field("field", this.field() + ":synthetic_source_delegate");
            builder.field("next", (ToXContent)this.next(), params);
            builder.field("source", this.source().toString());
            builder.endObject();
        }

        public TransportVersion getMinimalSupportedVersion() {
            throw new UnsupportedOperationException("Not serialized");
        }

        protected final Query doToQuery(SearchExecutionContext context) throws IOException {
            MappedFieldType ft = context.getFieldType(this.field());
            if (ft == null) {
                return new MatchNoDocsQuery("missing field [" + this.field() + "]");
            }
            ft = ((TextFieldMapper.TextFieldType)ft).syntheticSourceDelegate();
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(this.next().toQuery(context), BooleanClause.Occur.FILTER);
            SingleValueMatchQuery singleValueQuery = new SingleValueMatchQuery(context.getForField(ft, MappedFieldType.FielddataOperation.SEARCH), Warnings.createWarnings((DriverContext.WarningsMode)DriverContext.WarningsMode.COLLECT, (int)this.source().source().getLineNumber(), (int)this.source().source().getColumnNumber(), (String)this.source().text()), "single-value function encountered multi-value");
            singleValueQuery = singleValueQuery.rewrite(context.searcher());
            if (!(singleValueQuery instanceof MatchAllDocsQuery)) {
                builder.add((Query)singleValueQuery, BooleanClause.Occur.FILTER);
            }
            TermQuery ignored = new TermQuery(new Term("_ignored", ft.name()));
            if (!((ignored = ignored.rewrite(context.searcher())) instanceof MatchNoDocsQuery)) {
                builder.add((Query)ignored, BooleanClause.Occur.MUST_NOT);
            }
            return builder.build();
        }

        @Override
        protected AbstractBuilder rewrite(QueryBuilder next) {
            return new Builder(next, this.field(), this.source());
        }
    }

    public static class NegatedSyntheticSourceDelegateBuilder
    extends AbstractBuilder {
        NegatedSyntheticSourceDelegateBuilder(QueryBuilder next, String field, Source source) {
            super(next, field, source);
        }

        public String getWriteableName() {
            throw new UnsupportedOperationException("Not serialized");
        }

        protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("negated_" + SingleValueQuery.ENTRY.name);
            builder.field("field", this.field() + ":synthetic_source_delegate");
            builder.field("next", (ToXContent)this.next(), params);
            builder.field("source", this.source().toString());
            builder.endObject();
        }

        public TransportVersion getMinimalSupportedVersion() {
            throw new UnsupportedOperationException("Not serialized");
        }

        protected final Query doToQuery(SearchExecutionContext context) throws IOException {
            MappedFieldType ft = context.getFieldType(this.field());
            if (ft == null) {
                return new MatchNoDocsQuery("missing field [" + this.field() + "]");
            }
            ft = ((TextFieldMapper.TextFieldType)ft).syntheticSourceDelegate();
            Query svNext = this.simple(ft, context);
            TermQuery ignored = new TermQuery(new Term("_ignored", ft.name()));
            if ((ignored = ignored.rewrite(context.searcher())) instanceof MatchNoDocsQuery) {
                return svNext;
            }
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(svNext, BooleanClause.Occur.SHOULD);
            builder.add((Query)ignored, BooleanClause.Occur.SHOULD);
            return builder.build();
        }

        @Override
        protected AbstractBuilder rewrite(QueryBuilder next) {
            return new Builder(next, this.field(), this.source());
        }
    }

    public static abstract class AbstractBuilder
    extends AbstractQueryBuilder<AbstractBuilder> {
        private final QueryBuilder next;
        private final String field;
        private final Source source;

        AbstractBuilder(QueryBuilder next, String field, Source source) {
            this.next = next;
            this.field = field;
            this.source = source;
        }

        AbstractBuilder(StreamInput in) throws IOException {
            super(in);
            this.next = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
            this.field = in.readString();
            if (in instanceof PlanStreamInput) {
                PlanStreamInput psi = (PlanStreamInput)in;
                this.source = Source.readFrom((StreamInput)psi);
            } else {
                this.source = Source.readEmpty((StreamInput)in);
            }
        }

        protected final void doWriteTo(StreamOutput out) throws IOException {
            out.writeNamedWriteable((NamedWriteable)this.next);
            out.writeString(this.field);
            this.source.writeTo(out);
        }

        public QueryBuilder next() {
            return this.next;
        }

        public String field() {
            return this.field;
        }

        public Source source() {
            return this.source;
        }

        protected abstract AbstractBuilder rewrite(QueryBuilder var1);

        protected final QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
            QueryBuilder rewritten = this.next.rewrite(queryRewriteContext);
            if (rewritten instanceof MatchNoneQueryBuilder) {
                return rewritten;
            }
            if (rewritten == this.next) {
                return this;
            }
            return this.rewrite(rewritten);
        }

        protected final boolean doEquals(AbstractBuilder other) {
            return this.next.equals((Object)other.next) && this.field.equals(other.field);
        }

        protected final int doHashCode() {
            return Objects.hash(this.next, this.field);
        }

        protected final Query simple(MappedFieldType ft, SearchExecutionContext context) throws IOException {
            SingleValueMatchQuery singleValueQuery = new SingleValueMatchQuery(context.getForField(ft, MappedFieldType.FielddataOperation.SEARCH), Warnings.createWarnings((DriverContext.WarningsMode)DriverContext.WarningsMode.COLLECT, (int)this.source().source().getLineNumber(), (int)this.source().source().getColumnNumber(), (String)this.source().text()), "single-value function encountered multi-value");
            Query rewrite = singleValueQuery.rewrite(context.searcher());
            if (rewrite instanceof MatchAllDocsQuery) {
                return this.next().toQuery(context);
            }
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(this.next().toQuery(context), BooleanClause.Occur.FILTER);
            builder.add(rewrite, BooleanClause.Occur.FILTER);
            return builder.build();
        }

        public String fieldName() {
            return this.field;
        }
    }
}

