/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PruneEmptyPlans;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.LocalPropagateEmptyRelation;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.rule.Rule;

public class PropagateEmptyRelation
extends OptimizerRules.ParameterizedOptimizerRule<UnaryPlan, LogicalOptimizerContext>
implements OptimizerRules.LocalAware<UnaryPlan> {
    public PropagateEmptyRelation() {
        super(OptimizerRules.TransformDirection.DOWN);
    }

    @Override
    protected LogicalPlan rule(UnaryPlan plan, LogicalOptimizerContext ctx) {
        LocalRelation local;
        LogicalPlan p = plan;
        LogicalPlan logicalPlan = plan.child();
        if (logicalPlan instanceof LocalRelation && (local = (LocalRelation)logicalPlan).hasEmptySupplier()) {
            Aggregate agg;
            if (plan instanceof Aggregate && (agg = (Aggregate)plan).groupings().isEmpty()) {
                List<Block> emptyBlocks = this.aggsFromEmpty(ctx.foldCtx(), agg.aggregates());
                p = PropagateEmptyRelation.replacePlanByRelation(plan, LocalSupplier.of((Block[])emptyBlocks.toArray(Block[]::new)));
            } else {
                p = PruneEmptyPlans.skipPlan(plan);
            }
        }
        return p;
    }

    private List<Block> aggsFromEmpty(FoldContext foldCtx, List<? extends NamedExpression> aggs) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        BlockFactory blockFactory = PlannerUtils.NON_BREAKING_BLOCK_FACTORY;
        boolean i = false;
        for (NamedExpression namedExpression : aggs) {
            Expression expression = Alias.unwrap((Expression)namedExpression);
            if (expression instanceof AggregateFunction) {
                AggregateFunction aggFunc = (AggregateFunction)expression;
                this.aggOutput(foldCtx, namedExpression, aggFunc, blockFactory, blocks);
                continue;
            }
            throw new EsqlIllegalArgumentException("Did not expect a non-aliased aggregation {}", namedExpression);
        }
        return blocks;
    }

    protected void aggOutput(FoldContext foldCtx, NamedExpression agg, AggregateFunction aggFunc, BlockFactory blockFactory, List<Block> blocks) {
        Count count;
        Long value = aggFunc instanceof Count && (!(count = (Count)aggFunc).foldable() || count.fold(foldCtx) != null) ? Long.valueOf(0L) : null;
        BlockUtils.BuilderWrapper wrapper = BlockUtils.wrapperFor((BlockFactory)blockFactory, (ElementType)PlannerUtils.toElementType(aggFunc.dataType()), (int)1);
        wrapper.accept((Object)value);
        blocks.add(wrapper.builder().build());
    }

    private static LogicalPlan replacePlanByRelation(UnaryPlan plan, LocalSupplier supplier) {
        return new LocalRelation(plan.source(), plan.output(), supplier);
    }

    @Override
    public Rule<UnaryPlan, LogicalPlan> local() {
        return new LocalPropagateEmptyRelation();
    }
}

