/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.TopN;

public final class CombineLimitTopN
extends OptimizerRules.OptimizerRule<Limit> {
    public CombineLimitTopN() {
        super(OptimizerRules.TransformDirection.DOWN);
    }

    @Override
    public LogicalPlan rule(Limit limit) {
        LogicalPlan logicalPlan = limit.child();
        if (logicalPlan instanceof TopN) {
            TopN topn = (TopN)logicalPlan;
            int thisLimitValue = Foldables.limitValue(limit.limit(), limit.sourceText());
            int topNValue = Foldables.limitValue(topn.limit(), topn.sourceText());
            if (topNValue <= thisLimitValue) {
                return topn;
            }
            return new TopN(topn.source(), topn.child(), topn.order(), limit.limit(), topn.local());
        }
        logicalPlan = limit.child();
        if (logicalPlan instanceof Project) {
            Project proj = (Project)logicalPlan;
            return proj.replaceChild(limit.replaceChild(proj.child()));
        }
        return limit;
    }
}

