/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DataTypeConverter;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromStringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIntegerFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class ToInteger
extends AbstractConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToInteger", ToInteger::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.INTEGER, (source, fieldEval) -> fieldEval), Map.entry(DataType.BOOLEAN, ToIntegerFromBooleanEvaluator.Factory::new), Map.entry(DataType.DATETIME, ToIntegerFromLongEvaluator.Factory::new), Map.entry(DataType.KEYWORD, ToIntegerFromStringEvaluator.Factory::new), Map.entry(DataType.TEXT, ToIntegerFromStringEvaluator.Factory::new), Map.entry(DataType.DOUBLE, ToIntegerFromDoubleEvaluator.Factory::new), Map.entry(DataType.UNSIGNED_LONG, ToIntegerFromUnsignedLongEvaluator.Factory::new), Map.entry(DataType.LONG, ToIntegerFromLongEvaluator.Factory::new), Map.entry(DataType.COUNTER_INTEGER, (source, fieldEval) -> fieldEval));

    @FunctionInfo(returnType={"integer"}, description="Converts an input value to an integer value.\nIf the input parameter is of a date type, its value will be interpreted as milliseconds\nsince the {wikipedia}/Unix_time[Unix epoch], converted to integer.\nBoolean `true` will be converted to integer `1`, `false` to `0`.", examples={@Example(file="ints", tag="to_int-long", explanation="Note that in this example, the last value of the multi-valued field cannot be converted as an integer.\nWhen this happens, the result is a `null` value. In this case a _Warning_ header is added to the response.\nThe header will provide information on the source of the failure:\n\n`\"Line 1:61: evaluation of [TO_INTEGER(long)] failed, treating result as null. Only first 20 failures recorded.\"`\n\nA following header will contain the failure reason and the offending value:\n\n`\"org.elasticsearch.xpack.esql.core.InvalidArgumentException: [501379200000] out of [integer] range\"`")})
    public ToInteger(Source source, @Param(name="field", type={"boolean", "date", "keyword", "text", "double", "long", "unsigned_long", "integer", "counter_integer"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression field) {
        super(source, field);
    }

    private ToInteger(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToInteger.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.INTEGER;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToInteger(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToInteger::new, (Object)this.field());
    }

    static int fromBoolean(boolean bool) {
        return bool ? 1 : 0;
    }

    static int fromKeyword(BytesRef in) {
        return EsqlDataTypeConverter.stringToInt(in.utf8ToString());
    }

    static int fromDouble(double dbl) {
        return DataTypeConverter.safeToInt((double)dbl);
    }

    static int fromUnsignedLong(long ul) {
        return EsqlDataTypeConverter.unsignedLongToInt(ul);
    }

    static int fromLong(long lng) {
        return DataTypeConverter.safeToInt((long)lng);
    }
}

