/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeoShape;

public final class ToGeoShapeFromGeoGridEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ToGeoShapeFromGeoGridEvaluator.class);
    private final EvalOperator.ExpressionEvaluator in;
    private final DataType dataType;

    public ToGeoShapeFromGeoGridEvaluator(Source source, EvalOperator.ExpressionEvaluator in, DataType dataType, DriverContext driverContext) {
        super(driverContext, source);
        this.in = in;
        this.dataType = dataType;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.in;
    }

    @Override
    public Block evalVector(Vector v) {
        LongVector vector = (LongVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            try {
                return this.driverContext.blockFactory().newConstantBytesRefBlockWith(this.evalValue(vector, 0), positionCount);
            }
            catch (IllegalArgumentException e) {
                this.registerException(e);
                return this.driverContext.blockFactory().newConstantNullBlock(positionCount);
            }
        }
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    builder.appendBytesRef(this.evalValue(vector, p));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.registerException(e);
                    builder.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private BytesRef evalValue(LongVector container, int index) {
        long value = container.getLong(index);
        return ToGeoShape.fromGeoGrid(value, this.dataType);
    }

    @Override
    public Block evalBlock(Block b) {
        LongBlock block = (LongBlock)b;
        int positionCount = block.getPositionCount();
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    try {
                        BytesRef value = this.evalValue(block, i);
                        if (!positionOpened && valueCount > 1) {
                            builder.beginPositionEntry();
                            positionOpened = true;
                        }
                        builder.appendBytesRef(value);
                        valuesAppended = true;
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        this.registerException(e);
                    }
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private BytesRef evalValue(LongBlock container, int index) {
        long value = container.getLong(index);
        return ToGeoShape.fromGeoGrid(value, this.dataType);
    }

    public String toString() {
        return "ToGeoShapeFromGeoGridEvaluator[in=" + String.valueOf(this.in) + ", dataType=" + String.valueOf(this.dataType) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.in);
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.in.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory in;
        private final DataType dataType;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory in, DataType dataType) {
            this.source = source;
            this.in = in;
            this.dataType = dataType;
        }

        public ToGeoShapeFromGeoGridEvaluator get(DriverContext context) {
            return new ToGeoShapeFromGeoGridEvaluator(this.source, this.in.get(context), this.dataType, context);
        }

        public String toString() {
            return "ToGeoShapeFromGeoGridEvaluator[in=" + String.valueOf(this.in) + ", dataType=" + String.valueOf(this.dataType) + "]";
        }
    }
}

