/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.grouping;

import java.util.List;
import java.util.function.BiConsumer;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisPlanVerificationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.function.Function;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public abstract sealed class GroupingFunction
extends Function
implements PostAnalysisPlanVerificationAware {
    protected GroupingFunction(Source source, List<Expression> fields) {
        super(source, fields);
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postAnalysisPlanVerification() {
        return (p, failures) -> {
            if (!(p instanceof Aggregate)) {
                p.forEachExpression(GroupingFunction.class, gf -> failures.add(Failure.fail(gf, "cannot use grouping function [{}] outside of a STATS command", new Object[]{gf.sourceText()})));
            }
        };
    }

    public static abstract non-sealed class EvaluatableGroupingFunction
    extends GroupingFunction
    implements EvaluatorMapper {
        protected EvaluatableGroupingFunction(Source source, List<Expression> fields) {
            super(source, fields);
        }

        public Object fold(FoldContext ctx) {
            return EvaluatorMapper.super.fold(this.source(), ctx);
        }
    }

    public static abstract non-sealed class NonEvaluatableGroupingFunction
    extends GroupingFunction {
        protected NonEvaluatableGroupingFunction(Source source, List<Expression> fields) {
            super(source, fields);
        }
    }
}

