/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.PresentAggregatorFunction;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Present
extends AggregateFunction
implements ToAggregator {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Present", Present::new);

    @FunctionInfo(returnType={"boolean"}, description="Returns true if the input expression yields any non-null values within the current aggregation context. Otherwise it returns false.", type=FunctionType.AGGREGATE, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.GA, version="9.2.0")}, examples={@Example(file="present", tag="present"), @Example(description="To check for the presence inside a group use `PRESENT()` and `BY` clauses", file="present", tag="present-by"), @Example(description="To check for the presence and return 1 when it's true and 0 when it's false", file="present", tag="present-as-integer")})
    public Present(Source source, @Param(name="field", type={"aggregate_metric_double", "boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Expression that outputs values to be checked for presence.") Expression field) {
        this(source, field, (Expression)Literal.TRUE);
    }

    public Present(Source source, Expression field, Expression filter) {
        super(source, field, filter, Collections.emptyList());
    }

    private Present(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Present.ENTRY.name;
    }

    protected NodeInfo<Present> info() {
        return NodeInfo.create((Node)this, Present::new, (Object)this.field(), (Object)this.filter());
    }

    @Override
    public AggregateFunction withFilter(Expression filter) {
        return new Present(this.source(), this.field(), filter);
    }

    public Present replaceChildren(List<Expression> newChildren) {
        return new Present(this.source(), newChildren.get(0), newChildren.get(1));
    }

    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        return PresentAggregatorFunction.supplier();
    }

    public Nullability nullable() {
        return Nullability.FALSE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), dt -> !dt.isCounter() && dt != DataType.DENSE_VECTOR, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"any type except counter types or dense_vector"});
    }
}

