/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.metric;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.telemetry.metric.LongWithAttributes;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public final class SecurityCacheMetrics {
    public static <K, V> List<AutoCloseable> registerAsyncCacheMetrics(MeterRegistry registry, Cache<K, V> cache, CacheType type) {
        ArrayList<AutoCloseable> metrics = new ArrayList<AutoCloseable>();
        metrics.add((AutoCloseable)registry.registerLongAsyncCounter(type.metricsPrefix + ".hit.total", "Total number of cache hits.", "count", () -> new LongWithAttributes(cache.stats().getHits())));
        metrics.add((AutoCloseable)registry.registerLongAsyncCounter(type.metricsPrefix + ".miss.total", "Total number of cache misses.", "count", () -> new LongWithAttributes(cache.stats().getMisses())));
        metrics.add((AutoCloseable)registry.registerLongAsyncCounter(type.metricsPrefix + ".eviction.total", "Total number of cache evictions.", "count", () -> new LongWithAttributes(cache.stats().getEvictions())));
        metrics.add((AutoCloseable)registry.registerLongGauge(type.metricsPrefix + ".count.current", "The current number of cache entries.", "count", () -> new LongWithAttributes((long)cache.count())));
        return metrics;
    }

    private SecurityCacheMetrics() {
        throw new IllegalAccessError();
    }

    public static enum CacheType {
        API_KEY_AUTH_CACHE("es.security.api_key.auth_cache"),
        API_KEY_DOCS_CACHE("es.security.api_key.doc_cache"),
        API_KEY_ROLE_DESCRIPTORS_CACHE("es.security.api_key.role_descriptor_cache");

        private final String metricsPrefix;

        private CacheType(String metricsPrefix) {
            this.metricsPrefix = metricsPrefix;
        }

        public String metricsPrefix() {
            return this.metricsPrefix;
        }
    }
}

